---
title: Find and Accelerate the Loops That Tip Your Market
impact: HIGH
tags: growth-loops, tipping, virality, word-of-mouth
---

## Find and Accelerate the Loops That Tip Your Market

Every marketplace has natural growth loops where usage creates more users. Find them, then pour fuel on them. The loops that tip your market are often different from the loops that get you started.

**Incorrect (missing the loop):**

> **B2B food ordering marketplace (early REKKI):**
> "We're growing by having salespeople knock on restaurant doors. We project needing 50 salespeople to reach $10M GMV."
>
> **Cost model:**
> - CAC: $800 per restaurant
> - Forever dependent on sales team
> - Linear growth requires linear investment
> - No path to tipping

**Correct (finding and accelerating the loop):**

> **Same marketplace, after finding the loop:**
>
> **The discovery:** Suppliers receiving orders via REKKI started asking: "Can you get my other customers on this? I'd rather get all my orders this way."
>
> **The acceleration:** REKKI now asks suppliers to share their customer lists. Instead of cold-calling restaurants, they warm-intro from existing suppliers.
>
> **The economics:**
> - CAC dropped from $800 to $200
> - Conversion rate tripled (supplier referral vs. cold call)
> - Growth became exponential, not linear
> - Each new restaurant benefits suppliers, who refer more restaurants

**Growth loop patterns to look for:**

| Loop Type | Example |
|-----------|---------|
| Buyer → Buyer | Hipcamp: "Join my camping trip reservation" |
| Seller → Seller | Uber: Driver referral bonuses |
| Seller → Buyer | Etsy: Sellers give business cards linking to their store |
| Buyer → Seller | Faire: "Tell your suppliers to join so ordering is easier" |
| Transaction → SEO | Each listing creates a page that ranks in Google |

**How to accelerate once found:**

1. **Remove friction** - Make sharing one click
2. **Add incentives** - Uber paid drivers $500 per referral at peak
3. **Build it into the product** - Hipcamp trip invitations are core functionality
4. **Instrument and measure** - Know which loops produce highest LTV users

**Why it matters:**

The difference between a marketplace that tips and one that grinds is usually one well-accelerated growth loop. Before tipping, every customer is acquired manually. After finding the loop, customers bring customers. This is the moment that transforms unit economics.
