---
title: Build Happiness Loops That Reward Quality and Churn Poor Performers
impact: HIGH
tags: quality, loops, ratings, search-ranking
---

## Build Happiness Loops That Reward Quality and Churn Poor Performers

Growth loops bring users in. Happiness loops ensure quality over time. Without happiness loops, growth dilutes quality. The best marketplaces have built-in mechanisms that automatically reward great suppliers and push out poor ones.

**Incorrect (growth without happiness loops):**

> **Food delivery marketplace:**
> "We grew 10x this year! We went from 100 restaurants to 1,000."
>
> **What they don't mention:**
> - Average rating dropped from 4.6 to 4.1
> - On-time delivery rate fell from 92% to 71%
> - Buyer retention at 90 days dropped from 55% to 38%
> - Support tickets per order doubled
>
> **The problem:** They added suppliers without mechanisms to surface good ones and remove bad ones. Growth diluted quality.

**Correct (happiness loops that maintain quality):**

> **Food delivery marketplace with happiness loops:**
>
> **Search ranking rewards quality:**
> - Restaurants with higher ratings appear higher in search
> - On-time delivery rate factors into ranking
> - Buyer reorder rate influences visibility
>
> **Bad suppliers naturally churn:**
> - Poor ratings → Less visibility → Fewer orders → Restaurant leaves
> - Late deliveries → Lower ranking → Not worth being on platform
>
> **Good suppliers are rewarded:**
> - High ratings → Prime placement → More orders → Success breeds success
> - Best restaurants get "Featured" badges
>
> **Result:** "We grew 10x and average rating stayed at 4.6. Our growth loops brought in new restaurants, but our happiness loops ensured only quality restaurants thrived."

**The kidney metaphor:** Happiness loops are the kidneys of your marketplace - they filter out toxins. Without them, growth poisons the system.

**Happiness loop checklist:**
- [ ] Does search ranking reward quality signals?
- [ ] Do ratings and reviews affect supplier visibility?
- [ ] Is there natural churn for poor performers?
- [ ] Do the best suppliers get meaningfully better treatment?
- [ ] Does the system improve as it scales, not just grow?

**Why it matters:**

Consumer social products try to retain everyone. Marketplaces should strategically churn poor suppliers. Healthy churn on the supply side is a feature, not a bug - it maintains the quality that keeps buyers coming back.
