---
title: Not All Markets Can Tip - Check the Conditions First
impact: CRITICAL
tags: tipping, market-structure, defensibility
---

## Not All Markets Can Tip - Check the Conditions First

Tipping requires specific market conditions. If your market doesn't have them, you'll never achieve the winner-take-most dynamics that make marketplaces defensible. Check these conditions before investing years of effort.

**Incorrect (ignoring tipping conditions):**

> **Marketplace pitch for enterprise software resale:**
> "We're building a marketplace for used enterprise software licenses. Companies pay millions for licenses they don't fully use - we'll let them resell excess capacity."
>
> **Red flags ignored:**
> - Supply is concentrated (10 vendors dominate)
> - Transactions are one-time (companies don't frequently buy/sell)
> - High switching costs (enterprise contracts lock in buyers)
> - Existing vendors actively block secondary markets
>
> **Result:** Three years later, the startup has facilitated some transactions but the market never tips. Each deal requires heavy sales effort. There's no flywheel.

**Correct (validating tipping conditions):**

Before building, check:

> **Tipping conditions checklist:**
>
> | Condition | Craft marketplace | Enterprise software resale |
> |-----------|-------------------|---------------------------|
> | Fragmented supply | Yes - millions of makers | No - 10 vendors |
> | Heterogeneous supply | Yes - every product unique | No - licenses are commodities |
> | Repeated transactions | Yes - buyers keep discovering | No - one-time purchases |
> | Low switching costs | Yes - can buy anywhere | No - locked into vendors |
> | No dominant incumbent | Yes - only Etsy at scale | No - vendors control distribution |
> | Clear market boundary | Yes - "handmade goods" | Unclear - overlaps with direct sales |
>
> **Decision:** The craft marketplace can tip. Enterprise software resale structurally cannot.

**Why it matters:**

Some markets look like opportunities but are structurally resistant to tipping. Without tipping, you're just building a brokerage that requires salespeople forever. The whole point of enduring marketplace pain is the eventual flywheel - if it can't spin, choose a different market.
