---
title: Low-Frequency Purchases Require Different Strategies
impact: HIGH
tags: frequency, retention, mind-share, ltv
---

## Low-Frequency Purchases Require Different Strategies

If customers only need you once a year, they'll forget you exist. Low-frequency marketplaces must either expand use cases, stay top-of-mind through other means, or accept higher CAC and different unit economics.

**Incorrect (treating low-frequency like high-frequency):**

> **Home services marketplace strategy:**
> "Just like Uber for rides, we'll be the default for plumbers. Use us once, love us, use us forever."
>
> **Reality:**
> - Customer uses you for a plumber. Great experience.
> - 18 months later, they need an electrician.
> - They've forgotten you exist. They Google "electrician near me."
> - Your $50 CAC just bought you one transaction.
>
> **The Thumbtack problem:** By the time someone needs another home service, they're starting their search from scratch. The marketplace doesn't own the relationship.

**Correct (strategies for low-frequency):**

**Option 1: Expand categories to increase frequency**

> "You only need a plumber once a year, but you need *some* home service several times a year. If we're your plumber, electrician, cleaner, handyman, and landscaper, we're top of mind."
>
> Trade-off: Harder to achieve focus and quality across categories.

**Option 2: Stay in touch between transactions**

> "We send monthly home maintenance tips. Annual reminders for HVAC checkups. We're in their inbox regularly so when they need us, they remember."
>
> Trade-off: Costs money, risks being annoying.

**Option 3: Accept the economics and price accordingly**

> "We know customers might only use us once. We charge a meaningful fee for that one transaction and don't expect repeat usage. Our CAC math is based on single-transaction LTV."
>
> Trade-off: Hard to build a flywheel on one-time transactions.

**Option 4: Own a specific high-frequency wedge**

> "We started with cleaning - weekly/biweekly frequency. Customers know us from cleaning. When they need a plumber, they think of us first."
>
> This is the DoorDash strategy: Own food delivery (high frequency), then expand to retail.

**Why it matters:**

The Uber model - use us, love us, use us again tomorrow - only works for frequent purchases. Marketplaces for infrequent purchases require conscious strategy around the frequency problem, or they become expensive lead-gen businesses rather than flywheels.
