---
title: Time Your Take Rate to the Value You Provide
impact: HIGH
tags: monetization, take-rate, pricing, value
---

## Time Your Take Rate to the Value You Provide

Your take rate should match the value you're providing at each stage. Early on, the value is in the match. Over time, long-term relationships don't need you anymore. Price accordingly or face disintermediation.

**Incorrect (constant take rate through lifecycle):**

> **Freelance marketplace approach:**
> "We charge 20% of all transactions, forever. That's how we make money."
>
> **What happens:**
> - Year 1: Client finds freelancer through marketplace. 20% feels fair for the discovery.
> - Year 2: Client has worked with same freelancer for 50 projects. They know and trust each other.
> - Year 3: Freelancer says "Why don't you just pay me directly? Here's my Venmo."
>
> **Result:** Your best, most stable relationships disintermediate. You're left with only new, unproven matches that require more support.

**Correct (value-aligned pricing):**

> **Freelance marketplace approach:**
>
> | Relationship stage | Value provided | Take rate |
> |-------------------|----------------|-----------|
> | New match | Discovery, vetting, trust | 20% |
> | Established (5+ projects) | Payment processing, dispute resolution | 10% |
> | Long-term (20+ projects) | Record keeping, backup | 5% |
>
> "We reduce our take rate as relationships mature because our value shifts from matchmaking to infrastructure. This keeps long-term relationships on-platform and generates reliable, lower-margin revenue."

Alternative approaches:
- Subscription model instead of per-transaction
- Lead generation fee (pay once for the introduction)
- Tiered services with premium features for ongoing relationships

**Why it matters:**

The Thumbtack delivery guy who hands out his business card is rational - the marketplace added no value after the first connection. If you don't evolve your pricing to match your value, your best customers will leave. Better to earn 5% of a retained relationship than 0% of a disintermediated one.
