---
title: Focus on the Right Side at the Right Time
impact: CRITICAL
tags: supply, demand, chicken-egg, lifecycle
---

## Focus on the Right Side at the Right Time

The relative importance of supply vs. demand shifts across the marketplace lifecycle. Early stage: aggregate supply. At scale: corner demand. Getting this backwards wastes resources and slows tipping.

**Incorrect (wrong side at wrong time):**

> **Early-stage food delivery startup:**
> "We have 200 restaurants on the platform. Now we're investing heavily in consumer marketing - billboards, Instagram ads, influencer partnerships. We need to drive demand!"
>
> **Result:**
> - Consumers arrive but can't find what they want
> - Low restaurant density means long delivery times
> - Demand churns; ad spend is wasted
> - Restaurants see low order volume and lose interest

Or the opposite error at scale:

> **Mature marketplace:**
> "We're dominant in 15 cities but growth is slowing. Let's focus on onboarding more suppliers - 2x the restaurant count should 2x our growth!"
>
> **Result:**
> - Existing restaurants see their order share diluted
> - Quality diluted by marginal new suppliers
> - Buyer experience doesn't improve (already had enough choices)
> - Best suppliers start considering alternatives

**Correct (right side at right time):**

> **Early-stage approach:**
> "We're in Austin with 200 restaurants. But downtown density is only 40%. Before we market to consumers, we're hitting 80% density in downtown. We're literally walking into restaurants and onboarding them this week."
>
> **Mature marketplace approach:**
> "We have strong supply in 15 cities. Our focus now is cornering demand - building habit, increasing order frequency, making us the default. We're investing in loyalty programs, subscription models, and making reordering frictionless."

The Bill Gurley insight: Early marketplace value comes from aggregating fragmented supply. Long-term defensibility comes from cornering demand.

**Why it matters:**

At each stage, you're either supply-constrained or demand-constrained. Fighting the wrong constraint is like pushing on a rope. The symptom changes - early supply problems look like low engagement; late demand problems look like seller churn - but the diagnosis requires understanding your stage.
