---
name: hooked-model
description: Use when asked to "build habit-forming products", "Hooked model", "trigger action reward investment", "create sticky behavior loops", or "design habit loops". Helps design products that form unprompted user habits. The Hooked Model (created by Nir Eyal) explains how products create habits through Trigger, Action, Variable Reward, and Investment.
---

# The Hooked Model

## What It Is

The Hooked Model is a framework for building products that create unprompted user engagement. The core insight: **habit-forming products connect to internal triggers through a repeating cycle of trigger, action, reward, and investment.**

When a product becomes a habit, users engage without external prompts. They don't need ads, emails, or notifications to come back. They return because the product has become their automatic response to an internal trigger like boredom, loneliness, uncertainty, or FOMO.

The key shift: Move from asking "How do we get users to open the app?" to asking "What internal trigger do we want to own, and how do we become the automatic response to it?"

## When to Use It

Use the Hooked Model when you need to:

- **Design features that drive repeat engagement** (not just one-time use)
- **Reduce dependency on external marketing** to bring users back
- **Improve retention and decrease churn** through habit formation
- **Understand why competitor products are so sticky** (reverse-engineer their hooks)
- **Create ethical engagement** that genuinely improves users' lives
- **Prioritize which features to build** based on habit potential
- **Increase customer lifetime value** through deeper product integration

## When Not to Use It

- The product is inherently infrequent (e.g., buying a house, annual insurance)
- Users should consciously evaluate each decision (e.g., financial trading, medical diagnosis)
- Habit formation would harm users rather than help them
- You want to manipulate users into behaviors against their interests

## Patterns

Detailed examples showing how to apply the Hooked Model correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [external-triggers-only](patterns/external-triggers-only.md) | Products that rely only on notifications never form habits |
| [action-too-hard](patterns/action-too-hard.md) | If the action requires effort, the habit loop breaks |
| [predictable-rewards](patterns/predictable-rewards.md) | Predictable rewards don't create craving; variable rewards do |
| [no-investment](patterns/no-investment.md) | Without investment, users have no stake in returning |
| [wrong-internal-trigger](patterns/wrong-internal-trigger.md) | Targeting the wrong emotion means the habit never sticks |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [dark-patterns-vs-ethical](patterns/dark-patterns-vs-ethical.md) | Hooks should improve users' lives, not exploit them |
| [rewards-of-the-tribe](patterns/rewards-of-the-tribe.md) | Social validation is one of the most powerful variable rewards |
| [rewards-of-the-hunt](patterns/rewards-of-the-hunt.md) | The search for resources and information drives engagement |
| [rewards-of-the-self](patterns/rewards-of-the-self.md) | Personal mastery and completion drive intrinsic motivation |
| [investment-loads-next-trigger](patterns/investment-loads-next-trigger.md) | The best investments create reasons to come back |
| [ability-before-motivation](patterns/ability-before-motivation.md) | Make the action easier before amplifying motivation |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [frequency-matters](patterns/frequency-matters.md) | Habits form faster with more frequent behaviors |
| [vitamin-vs-painkiller](patterns/vitamin-vs-painkiller.md) | The best habit-forming products start as vitamins and become painkillers |
| [manipulation-matrix](patterns/manipulation-matrix.md) | Use the matrix to evaluate whether your hook is ethical |


## Deep Dives

Read only when you need extra detail.

- `references/hooked-model-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Hooked: How to Build Habit-Forming Products* by Nir Eyal — the complete framework
- *Indistractable: How to Control Your Attention and Choose Your Life* by Nir Eyal — the flip side: helping users control habits

**Concepts Referenced:**
- B.J. Fogg's Behavior Model (B = MAT)
- Variable reinforcement from behavioral psychology
- Carol Dweck's research on mindset and willpower

**Related Frameworks:**
- Jobs-to-be-Done — Understanding why users "hire" products (complements the internal trigger analysis)
- Fogg Behavior Model — The underlying model for the Action phase

**From the Source:**
Nir Eyal on building ethical habit-forming products: "If it helps you become more productive, helps you live a happier, healthier life, that's wonderful... It's really about how do you get people to keep coming back to your product or service, not because they have to, but because they want to."
