---
title: Make the Action Easier Before Amplifying Motivation
impact: HIGH
tags: action, ability, friction, behavior-model
---

## Make the Action Easier Before Amplifying Motivation

When users aren't completing the action, teams often try to increase motivation (better copy, more incentives, stronger value props). But increasing ability (reducing friction) is almost always more effective and sustainable.

**Incorrect (increasing motivation to overcome friction):**

> **E-commerce checkout optimization:**
>
> PM: "Cart abandonment is 70%. Users aren't completing purchase."
>
> Marketing: "Let's add more urgency. 'Only 2 left in stock!' 'Sale ends tonight!' 'Don't miss out!'"
>
> PM: "And we'll offer a 10% discount popup before they leave."
>
> *Result:* Marginal improvement. Users who are motivated enough complete purchase. Everyone else still abandons because the 6-step checkout is still too hard.

**Correct (increasing ability by reducing friction):**

> **E-commerce checkout optimization:**
>
> PM: "Cart abandonment is 70%. What's making the action hard?"
>
> Designer: "Users have to create an account, enter shipping, enter billing, choose shipping speed, apply coupons, then confirm. That's six decision points."
>
> PM: "Can we make it one? Guest checkout with saved payment, one-click buy?"
>
> *Result:* Cart abandonment drops to 30%. Users who felt moderate motivation can now complete the action because ability is high.
>
> **The formula:** B = M × A × T. If Motivation is 5 and Ability is 1, Behavior = 5. If Motivation is 5 and Ability is 10, Behavior = 50.

**Why it matters:**

Motivation is variable and unreliable — it changes with mood, context, and time of day. Ability is structural and consistent — once you remove friction, it stays removed. Building your hook on low friction rather than high motivation means it works even when users aren't maximally motivated.

**Six factors of ability to optimize:**
1. Time — Make it faster
2. Money — Make it cheaper (or free)
3. Physical effort — Make it require less work
4. Brain cycles — Make it require less thinking
5. Social deviance — Make it feel normal
6. Non-routine — Make it fit existing habits
