---
title: The Most Habit-Forming Products Combine Multiple Reward Types
impact: HIGH
tags: variable-reward, engagement, product-design
---

## The Most Habit-Forming Products Combine Multiple Reward Types

Products that rely on a single reward type are vulnerable. Products that layer Tribe, Hunt, and Self rewards create multiple reasons to return and stronger habits.

**Incorrect (single reward type):**

> **Fitness app relying only on Self rewards:**
>
> User completes workout → "Great job! You burned 500 calories. 5-day streak!"
>
> The reward is purely about personal progress (Self). Users who are intrinsically motivated stick around, but there's no social pull or discovery element.
>
> *Result:* Users plateau in motivation. When the novelty of personal progress wears off, there's nothing else to keep them engaged.

**Correct (layering multiple reward types):**

> **Fitness app with layered rewards:**
>
> User completes workout →
> - **Self:** "Personal best! You ran faster than last week." (mastery)
> - **Tribe:** "Sarah gave you a high five. You're #3 on the weekly leaderboard." (social validation)
> - **Hunt:** "New badge unlocked! What's inside?" (discovery)
>
> Each completion offers variable rewards across all three types. Different users are motivated by different rewards, and all users have multiple reasons to return.
>
> *Result:* Even when personal progress plateaus, social and discovery rewards maintain engagement.

**Why it matters:**

Different users respond to different reward types. Some are motivated by mastery (Self), others by social validation (Tribe), others by discovery (Hunt). Layering all three means you're never dependent on a single motivation source, and users have multiple paths to habit formation.

**Example: Why social media is so sticky**
- **Tribe:** Likes, comments, followers, feeling connected
- **Hunt:** Scrolling to discover interesting content
- **Self:** Curating a profile, building follower count, creating content

All three reward types in one product, with infinite variability.
