---
title: Products That Rely Only on External Triggers Never Form Habits
impact: CRITICAL
tags: triggers, notifications, retention, habit-formation
---

## Products That Rely Only on External Triggers Never Form Habits

External triggers (notifications, emails, ads) are training wheels. If users only engage when prompted externally, they haven't formed a habit — they're just responding to interruptions.

**Incorrect (over-reliance on external triggers):**

> **Team discussion about retention:**
>
> PM: "Engagement is down. Users aren't opening the app."
>
> Growth Lead: "Let's increase push notification frequency. We'll send reminders every 4 hours instead of daily."
>
> PM: "And add more email re-engagement campaigns."
>
> *Three months later:* Notification opt-outs increased 40%, unsubscribes doubled, and retained users are the same people who would have returned anyway.

The product is treating the symptom (users don't return) instead of the disease (no internal trigger association).

**Correct (building internal trigger associations):**

> **Team discussion about retention:**
>
> PM: "Engagement is down. Users aren't opening the app without prompts. What internal trigger should we own?"
>
> Designer: "Our power users open the app when they feel uncertain about their schedule. They're seeking clarity."
>
> PM: "So we need users to *feel* 'Where am I supposed to be?' → *think* 'I'll check the app.' How do we build that association?"
>
> Growth Lead: "Let's use external triggers strategically — only at moments of uncertainty — so users learn the connection. After onboarding, we reduce notifications as the internal trigger takes over."
>
> *Three months later:* Users open the app without prompts when they feel uncertain about their day.

**Why it matters:**

As Nir Eyal notes: "90% of the time that we get distracted, it's not because of what's happening outside of us, but because of what's happening within — boredom, loneliness, fatigue, uncertainty, anxiety." Products that own an internal trigger don't need to constantly ping users.
