---
title: Habits Form Faster With More Frequent Behaviors
impact: MEDIUM
tags: frequency, habit-formation, product-design
---

## Habits Form Faster With More Frequent Behaviors

Habits require repetition to form. If the behavior happens infrequently, the association between internal trigger and product never solidifies, no matter how good your hook is.

**Incorrect (infrequent behavior, expecting habit):**

> **Tax preparation software team:**
>
> PM: "We want users to form a habit around tax preparation. Let's apply the Hooked Model."
>
> Designer: "Trigger: Anxiety about taxes. Action: Open app. Reward: Progress on tax return. Investment: Data entered."
>
> *Reality:* Users only prepare taxes once a year. By the time next year comes, they've forgotten the product exists. No habit forms because the behavior is too infrequent.
>
> *Result:* Heavy marketing spend every tax season to re-acquire the same users.

**Correct (increase frequency or attach to frequent behavior):**

> **Tax preparation software team:**
>
> PM: "Tax prep is annual, but we can attach to more frequent behaviors."
>
> Designer: "What if we track expenses and deductions throughout the year? That's a weekly or monthly behavior."
>
> PM: "Trigger: Receipt after purchase. Action: Snap photo. Reward: See tax savings accumulate. Investment: Database of deductions loads the annual trigger — 'Your tax return is already 60% done.'"
>
> *Result:* Users engage weekly. By tax season, they're habituated to the product and have switching costs (their year of data).

**Why it matters:**

| Frequency | Habit Potential |
|-----------|-----------------|
| Multiple times/day | Very high |
| Daily | High |
| Weekly | Medium |
| Monthly | Low |
| Yearly | Near zero |

If your core behavior is infrequent, either increase the frequency or create adjacent behaviors that are more frequent.
