---
title: Predictable Rewards Don't Create Craving
impact: CRITICAL
tags: variable-reward, engagement, psychology, anticipation
---

## Predictable Rewards Don't Create Craving

The brain's reward system is activated more by the *anticipation* of reward than by the reward itself. When rewards are predictable, anticipation disappears — and so does the craving to return.

**Incorrect (predictable rewards):**

> **Educational app design:**
>
> "Every time you complete a lesson, you get 10 points."
>
> Users complete a few lessons, earn their predictable 10 points each time, and stop caring. The reward is expected, so there's nothing to anticipate.
>
> *After initial use:* "I know exactly what I'll get. Why bother?"
>
> **Engagement flatlines after the novelty wears off.**

**Correct (variable rewards):**

> **Educational app design (variable rewards of the Hunt):**
>
> "Complete a lesson to reveal your reward." Sometimes 5 points, sometimes 50. Sometimes a badge. Sometimes a streak bonus. Sometimes nothing but a clever animation.
>
> Users complete lessons wondering, "What will I get this time?" The variability creates anticipation.
>
> **Engagement sustains** because the user can't predict what's next.
>
> **Even better — variable rewards of the Self:**
>
> "Complete a lesson and see how you compare to yesterday's performance." Some days you're faster. Some days you unlock a new level. Some days you break a personal record.
>
> The reward isn't just points — it's the variable sensation of mastery and progress.

**Why it matters:**

Slot machines pay out less than they take in, yet people keep pulling the lever. Why? Variable reinforcement. If a slot machine paid a fixed $0.90 for every $1 inserted, no one would play. It's the *variability* that creates the compulsion. The same principle applies to product engagement.
