---
title: Stored Value Should Compound Over Time
impact: HIGH
tags: investment, switching-costs, retention, stored-value
---

## Stored Value Should Compound Over Time

The best investments don't just create one-time switching costs — they create value that grows over time. The longer users stay, the more painful leaving becomes.

**Incorrect (investment that doesn't compound):**

> **Note-taking app:**
>
> User creates a few notes → Investment exists (their notes are here)
>
> But the value doesn't grow. 100 notes aren't meaningfully different from 10 notes. The user could export and switch to a competitor with minimal loss.
>
> *Result:* Low switching costs. Users leave when a shinier alternative appears.

**Correct (investment that compounds):**

> **Note-taking app with compounding value:**
>
> User creates notes → But also:
> - **Backlinks form** — Notes reference each other, creating a knowledge graph that only exists in this app
> - **Search history trains AI** — Recommendations improve based on usage patterns
> - **Collaboration builds** — Team workflows and shared spaces accumulate
> - **Templates accumulate** — Custom workflows that took hours to build
> - **Integration depth** — Connected to calendar, email, tasks, documents
>
> After a year, the user doesn't just have notes — they have a personalized knowledge system. Switching means rebuilding from scratch.
>
> *Result:* High switching costs that increase over time. Users become more locked in, not less.

**Why it matters:**

Investment should be like a bank account that compounds interest. The longer users stay, the more they have to lose. Products where investment doesn't compound have linear switching costs — and linear costs can be overcome. Products with compounding value have exponential switching costs — making switching increasingly unthinkable.

**Examples of compounding stored value:**
- Spotify: Years of listening history training recommendations
- Amazon: Purchase history, saved addresses, Prime benefits
- LinkedIn: Network connections, endorsements, history
- Notion: Templates, workflows, integrations, team processes
- Google Photos: Organized albums, face recognition, memories
