---
title: Targeting the Wrong Internal Trigger
impact: CRITICAL
tags: triggers, emotions, user-research, positioning
---

## Targeting the Wrong Internal Trigger

If you design your hook around an emotion users don't actually feel, the habit loop never starts. The internal trigger must be real, frequent, and something your product can genuinely address.

**Incorrect (assumed internal trigger):**

> **Productivity app team discussion:**
>
> PM: "Our users want to feel productive. That's the internal trigger we're designing for."
>
> Designer: "So when they feel unproductive, they'll open our app."
>
> *Reality check:* Users don't spontaneously "feel unproductive" — that's a rational assessment, not an emotion. The product struggles because there's no automatic emotional-product association.
>
> *Six months later:* "Users love the app when they use it, but they forget to open it."

**Correct (discovered internal trigger):**

> **Productivity app team discussion (after user research):**
>
> PM: "We interviewed 20 power users. When do they actually open the app?"
>
> Researcher: "When they feel *overwhelmed*. They open the app when their brain is swimming with too many things. The internal trigger is overwhelm and anxiety about forgetting something."
>
> PM: "So the hook is: Feel overwhelmed → Open app → Dump everything from brain → Feel relief (reward) → Organize and tag items (investment that loads tomorrow's trigger)."
>
> Designer: "That's different from 'feel productive.' We should design the entry point for brain-dumping, not task management."
>
> *Six months later:* Users open the app reflexively when they feel overwhelmed.

**Why it matters:**

You can't manufacture an internal trigger — you can only discover and associate with one that already exists. The trigger must be (1) a genuine emotion, (2) frequent enough for habit formation, and (3) something your product reliably addresses. Wrong trigger = no habit.
