# The Hooked Model Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Hook Cycle

Products create habits through a four-phase cycle that repeats:

```
    ┌────────────────────────────────────────────────────────┐
    │                                                        │
    ▼                                                        │
┌─────────┐     ┌─────────┐     ┌─────────────┐     ┌─────────────┐
│ TRIGGER │────▶│ ACTION  │────▶│   VARIABLE  │────▶│ INVESTMENT  │
│         │     │         │     │   REWARD    │     │             │
└─────────┘     └─────────┘     └─────────────┘     └─────────────┘
    │                                                        │
    │           The investment loads the next trigger        │
    └────────────────────────────────────────────────────────┘
```

**Each pass through the Hook creates a stronger association between the user's internal trigger and your product.**

### Phase 1: Trigger

Triggers are the actuators of behavior. They come in two types:

**External Triggers** — Environmental cues that tell users what to do next:
- Push notifications
- Email reminders
- Social media shares
- Ads and marketing
- Word of mouth
- App icons on the home screen

**Internal Triggers** — Emotions and states that prompt automatic behavior:
- Boredom ("I'm bored" → open TikTok)
- Loneliness ("I feel alone" → open Instagram)
- Uncertainty ("I don't know" → open Google)
- FOMO ("I'm missing out" → open Twitter)
- Anxiety ("I'm stressed" → open YouTube)

**The goal:** Use external triggers to create associations with internal triggers until users engage without any external prompt.

**Key insight from Nir Eyal:** "90% of the time that we get distracted, it's not because of what's happening outside of us, but because of what's happening within — boredom, loneliness, fatigue, uncertainty, anxiety. That is the cause of 90% of our distractions."

### Phase 2: Action

The action is the simplest behavior in anticipation of a reward. For a behavior to occur, three things must be present (Fogg Behavior Model):

```
B = MAT

Behavior = Motivation × Ability × Trigger
```

**All three must be present at the same moment.**

**Motivation** — The energy for action. Humans seek:
- Pleasure and avoid pain
- Hope and avoid fear
- Social acceptance and avoid rejection

**Ability** — How easy it is to perform the behavior. Six factors:
1. Time — How long does it take?
2. Money — What's the financial cost?
3. Physical effort — How much labor is required?
4. Brain cycles — How much thinking is needed?
5. Social deviance — Does it violate norms?
6. Non-routine — Does it require new behaviors?

**Key insight:** Always make the action easier before trying to increase motivation. Reducing friction is more effective than amplifying desire.

**Examples of low-friction actions:**
- Scrolling (infinite scroll)
- Tapping (like button)
- Swiping (Tinder)
- Voice ("Hey Alexa")

### Phase 3: Variable Reward

The reward fulfills the user's craving, but variability is the key that creates desire. The brain's reward system is activated more by the *anticipation* of reward than by the reward itself.

**Predictable rewards don't create habits.** Variable rewards do.

**Three types of variable rewards:**

**1. Rewards of the Tribe** — Social rewards
- Social validation (likes, comments, followers)
- Cooperation and competition
- Partnership and connectedness
- Recognition and empathy

*Examples:* Facebook likes, Stack Overflow reputation, Slack emoji reactions

**2. Rewards of the Hunt** — Search for resources
- Information (news, content, knowledge)
- Material goods (deals, products)
- Money (gambling, trading, variable compensation)

*Examples:* Twitter feed, Pinterest discovery, slot machines, Google search results

**3. Rewards of the Self** — Personal mastery
- Competence and completion
- Consistency and progress
- Achievement and mastery

*Examples:* Video game levels, Duolingo streaks, inbox zero, completing a puzzle

**Key insight:** The most habit-forming products combine multiple reward types.

### Phase 4: Investment

The investment phase increases the odds the user will return. Users invest something of value that improves the product with use and loads the next trigger.

**Types of investment:**
- **Time** — Building a profile, organizing content
- **Data** — Preferences, history, personalization
- **Effort** — Creating content, building skills
- **Social capital** — Followers, reputation, connections
- **Money** — In-app purchases, subscriptions

**Why investment matters:**

1. **Stored Value** — The product gets better with use (like a bank account that appreciates)
2. **Commitment and Consistency** — People want to be consistent with past behavior
3. **Escalation of Commitment** — The more invested, the harder to leave

**Investment loads the next trigger:**
- Follow someone → Their posts appear in your feed (next trigger)
- Upload music → Playlists get better recommendations (next trigger)
- Add friends → You get notified when they post (next trigger)
- Create content → You return to check engagement (next trigger)

## The Internal Trigger Canvas

To design effective hooks, start by understanding the internal trigger you want to own:

| Question | Answer |
|----------|--------|
| **Who is your user?** | (Specific persona, not "everyone") |
| **What is you user doing right before they would use your product?** | (The context that precedes use) |
| **What internal trigger (emotion) are they feeling?** | (Boredom, loneliness, uncertainty, fear, etc.) |
| **What is the external trigger that leads to the action?** | (How do they discover or remember to use it?) |
| **What is the simplest action in anticipation of reward?** | (One behavior, minimal friction) |
| **What variable reward satisfies but leaves them wanting more?** | (Tribe, Hunt, or Self) |
| **What investment increases the likelihood of return?** | (Stored value that loads next trigger) |

## How to Evaluate Your Hook

### The Habit Testing Process

1. **Identify** — Look at your data to find habitual users
   - Who uses the product repeatedly without external prompts?
   - What behaviors do they have in common?

2. **Codify** — Discover the "Habit Path"
   - What sequence of behaviors leads to habit formation?
   - What's the minimum viable engagement before habit kicks in?

3. **Modify** — Increase the percentage of users who follow the Habit Path
   - Remove friction from the path
   - Add variable rewards at key moments
   - Create investment opportunities

### Frequency and Habit Potential

Not all products can form habits. A behavior must occur frequently enough for a habit to form:

| Frequency | Habit Potential | Examples |
|-----------|-----------------|----------|
| Multiple times per day | Very high | Social media, messaging, search |
| Daily | High | Email, news, weather apps |
| Weekly | Medium | Grocery delivery, fitness tracking |
| Monthly | Low | Bill pay, subscription boxes |
| Yearly | None | Insurance, tax software |

**Rule of thumb:** If the behavior doesn't occur at least weekly, habit formation is difficult. Focus on increasing frequency or pairing with a more frequent behavior.

## The Manipulation Matrix

Before building hooks, evaluate the ethics of your product:

|                        | **Does the maker use it?** | **Does the maker NOT use it?** |
|------------------------|:--------------------------:|:------------------------------:|
| **Materially improves users' lives** | **Facilitator** (ethical) | **Peddler** (risky) |
| **Does NOT materially improve users' lives** | **Entertainer** (acceptable) | **Dealer** (unethical) |

**Facilitator** — You use the product and believe it improves lives. Keep building.

**Peddler** — You believe it helps users but wouldn't use it yourself. Examine why.

**Entertainer** — You use it for fun but it's not life-improving. Proceed with caution.

**Dealer** — You neither use it nor believe it helps. You're exploiting users. Stop.

**Key insight from Nir Eyal:** "For the vast majority of businesses out there, they're not worried about addicting anyone. The real problem the vast majority of businesses out there have is that nobody cares. They have a wonderful product that could really improve people's lives, but people aren't using it."

## Common Mistakes

### 1. Relying only on external triggers
If your product needs constant notifications to bring users back, it hasn't formed a habit. External triggers are training wheels — eventually, internal triggers should take over.

### 2. Making the action too hard
Every extra tap, every form field, every decision point reduces completion. Simplify ruthlessly. The action should be the absolute minimum behavior in anticipation of reward.

### 3. Using predictable rewards
If users know exactly what they'll get, there's no craving. The intermittent reinforcement of variable rewards is what drives the compulsion to return.

### 4. Skipping the investment phase
Without investment, users have nothing to lose by switching to a competitor. Investment creates switching costs and loads the next trigger.

### 5. Targeting behaviors that are too infrequent
You can't form a habit around a behavior that happens once a month. Either increase the frequency or attach to a more frequent behavior.

### 6. Confusing addiction with habit
As Nir Eyal notes: "Addiction is a compulsive dependency on a behavior or substance that *harms* the user. That's about 3% to 5% of the population." Habits that improve users' lives are the goal.

## Applying the Hooked Model: Checklists

### For Product Design

- [ ] What internal trigger does this feature address?
- [ ] What emotion do we want users to associate with our product?
- [ ] What's the simplest possible action in anticipation of reward?
- [ ] Have we reduced friction in all six ability factors?
- [ ] What variable reward creates anticipation and craving?
- [ ] Are we using Tribe, Hunt, or Self rewards (ideally multiple)?
- [ ] What investment loads the next trigger?
- [ ] How does the product get better with use?

### For Retention Analysis

- [ ] At what point do users become habitual? (Identify the habit path)
- [ ] What do retained users do that churned users don't?
- [ ] Where does the hook cycle break for churned users?
- [ ] Are we over-relying on external triggers?
- [ ] Is there sufficient variable reward to create anticipation?

### For Competitive Analysis

- [ ] What internal trigger does the competitor own?
- [ ] How simple is their core action?
- [ ] What variable rewards keep users engaged?
- [ ] What investments create switching costs?
- [ ] Where is their hook cycle weak or breakable?

### For Ethical Evaluation

- [ ] Would I use this product myself?
- [ ] Does it materially improve users' lives?
- [ ] Are we helping users achieve their goals or exploiting weaknesses?
- [ ] Could this cause harm to the 3-5% who are vulnerable to addiction?
- [ ] Where on the Manipulation Matrix does this product fall?

## Quick Reference

**The core idea:** Products form habits through a four-step cycle: Trigger → Action → Variable Reward → Investment. The investment loads the next trigger, creating a loop.

**Internal vs. External Triggers:** External triggers (notifications, ads) train users to associate your product with internal triggers (emotions). The goal is for internal triggers to drive engagement without external prompts.

**Make action easy:** Behavior = Motivation x Ability x Trigger. Increasing ability (reducing friction) is more effective than increasing motivation.

**Variable rewards:** Predictable rewards don't create craving. Variable rewards — of the Tribe (social), Hunt (resources), or Self (mastery) — create the anticipation that drives engagement.

**Investment creates lock-in:** Users who invest time, data, effort, social capital, or money are more likely to return. The investment should load the next trigger.

**Ethics matter:** Use the Manipulation Matrix. Be a Facilitator (you'd use it, it helps users) not a Dealer (you wouldn't use it, it exploits users).

---

