---
name: jobs-to-be-done
description: Use when asked to "jobs to be done", "JTBD", "why customers churn", "prep for customer interviews", "hire and fire products", or "find real competitors". Helps discover unmet needs and the context behind purchasing decisions. The Jobs to be Done framework (created by Clayton Christensen and Bob Moesta) explains why customers hire and fire products.
---

# Jobs-to-be-Done (JTBD)

## What It Is

Jobs-to-be-Done is a framework for understanding customer motivation. The core insight: **people don't buy products, they hire them to make progress in their lives.**

When someone buys a product, they're not buying features or benefits—they're hiring that product to do a job. Understanding that job unlocks everything: positioning, messaging, feature prioritization, and competitive strategy.

The key shift: Move from asking "What do customers want?" to asking "What progress are customers trying to make?"

## When to Use It

Use JTBD when you need to:

- **Understand why customers buy** (not just what they buy)
- **Discover your true competitive set** (often not who you think)
- **Find product-market fit** for a new product or feature
- **Improve positioning and messaging** that resonates
- **Reduce churn** by understanding why customers leave
- **Prioritize your roadmap** based on real customer progress
- **Identify new market opportunities** through struggling moments

## When Not to Use It

- There's no real customer choice (e.g., employer-mandated software)
- The purchase is pure habit with no conscious decision
- You want to validate a hypothesis you've already decided on

## Patterns

Detailed examples showing how to apply JTBD correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [interview-asking-why](patterns/interview-asking-why.md) | Don't ask "why did you buy" — ask "walk me through what happened" |
| [job-statement-too-broad](patterns/job-statement-too-broad.md) | "Save time" is useless — needs context + motivation + outcome |
| [missing-forces](patterns/missing-forces.md) | Analyze all four forces, not just Push and Pull |
| [interviewing-prospects](patterns/interviewing-prospects.md) | Only interview people who already switched |
| [conference-room-jtbd](patterns/conference-room-jtbd.md) | You can't hypothesize jobs without talking to customers |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [wrong-competitors](patterns/wrong-competitors.md) | Your real competitors are what customers do *instead* |
| [clustering-vs-segmenting](patterns/clustering-vs-segmenting.md) | Find pathways, don't segment by demographics |
| [complaints-arent-jobs](patterns/complaints-arent-jobs.md) | "Bitching ain't switching" — complaints don't predict action |
| [reducing-friction](patterns/reducing-friction.md) | Sometimes lowering anxiety beats adding features |
| [context-changes-everything](patterns/context-changes-everything.md) | Same person, different context = different job |
| [getting-past-pablum](patterns/getting-past-pablum.md) | First answers are generic — push 2-3 questions deeper |
| [milkshake-story](patterns/milkshake-story.md) | The classic example: same product, multiple jobs |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [three-energies](patterns/three-energies.md) | Address Functional, Emotional, and Social — all three matter |
| [following-power-users](patterns/following-power-users.md) | Power users will lead you away from what scales |


## Deep Dives

Read only when you need extra detail.

- `references/jobs-to-be-done-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Demand-Side Sales* by Bob Moesta — the tactical method
- *Competing Against Luck* by Clayton Christensen — the theory
- *When Coffee and Kale Compete* by Alan Klement — accessible introduction

**Other:**
- *Never Split the Difference* by Chris Voss — interview techniques that complement JTBD research
- *The End of Average* by Todd Rose — why demographic segmentation fails
