---
title: Cluster Into Pathways, Don't Segment by Demographics
impact: HIGH
tags: synthesis, analysis, segmentation
---

## Cluster Into Pathways, Don't Segment by Demographics

Traditional segmentation groups customers by who they are (demographics, firmographics). JTBD clusters customers by the pathway they took — the combination of push, pull, anxiety, and habit that led to their decision.

**Incorrect (demographic segmentation):**

> **Customer Segments:**
> - Enterprise (500+ employees): Want SSO, audit logs, dedicated support
> - Mid-market (50-500): Want integrations, team features
> - SMB (<50): Want simple pricing, easy setup
>
> **Strategy:** Build different feature sets for each segment.

**Correct (pathway clustering):**

> **Customer Pathways (jobs):**
>
> **Pathway A — "The Crisis Fixer"**
> Lost something important, boss is angry, need to show change is happening. Buys fast, willing to pay, doesn't comparison shop much. Needs: immediate value, visible change.
>
> **Pathway B — "The Process Optimizer"**
> Current tool works but team is scaling, seeing inefficiencies. Long evaluation, multiple stakeholders. Needs: proof it scales, migration support, team buy-in tools.
>
> **Pathway C — "The New Leader"**
> Just promoted or hired, wants to make their mark. Old tool is "the old way." Needs: to look smart to their team, quick wins to show progress.
>
> **Strategy:** These three pathways exist across all company sizes. A 50-person company in crisis mode looks more like a 500-person company in crisis mode than a 50-person company optimizing processes.

**Why it matters:**

Demographics tell you who might buy. Pathways tell you *why* they buy and *what* they need to hear. Two CTOs at similar companies may have completely different jobs — one is in crisis mode, one is optimizing. Same persona, different job, different sale.
