---
title: The Milkshake Story — Same Product, Different Jobs
impact: HIGH
tags: case-study, core-concept, classic-example
---

## The Milkshake Story — Same Product, Different Jobs

The most famous JTBD example: Clayton Christensen's team helped McDonald's sell more milkshakes by discovering that the same product was being hired for completely different jobs by different customers.

**The Setup:**

McDonald's wanted to sell more milkshakes. They did traditional market research — asked customers how to improve the milkshake. Make it thicker? More chocolate? Cheaper? They made changes based on feedback. Sales didn't budge.

**The JTBD Approach:**

Researchers stood in McDonald's for 18 hours watching who bought milkshakes and when. They noticed something surprising: 40% of milkshakes were sold before 8am, to solo customers who got in their car and drove away.

They interviewed these morning customers: *"What job did you hire that milkshake to do?"*

**Job #1 — Morning Commuters:**

> **Context:** Long, boring commute. Need something to do with one hand. Want to feel full until lunch.
>
> **Job:** "Make my boring commute less tedious and keep me full until noon."
>
> **Why milkshake wins:** Takes 20 minutes to finish (entertains the whole commute). Thick enough to last. Fits in cup holder. One hand. Filling.
>
> **Real competitors:** Bagels (messy, gone in 3 minutes), bananas (gone in 2 minutes, then what?), donuts (sugar crash), coffee (already have it, doesn't fill you up).

**Job #2 — Afternoon Parents:**

> **Context:** Parent with kid after school/activities. Kid wants treat. Parent wants to feel like good parent without going overboard.
>
> **Job:** "Help me say yes to my kid and feel like a good parent."
>
> **Why milkshake wins:** It's a treat. Takes a while (keeps kid busy). Not as bad as ice cream sundae.
>
> **Real competitors:** Ice cream (too indulgent), toy from store (too expensive), saying no (guilt).

**The Insight:**

Same product. Completely different jobs. The morning commuter wants a *thicker, longer-lasting* milkshake. The afternoon parent might want a *smaller, quicker* milkshake. Traditional segmentation ("milkshake customers") would average these needs and satisfy neither.

**Why it matters:**

You don't have "customers." You have jobs. The milkshake doesn't compete with Burger King's milkshake — it competes with bagels, boredom, bananas, and guilt. Understanding the job changes everything: product design, marketing, competition, and pricing.

**Reference:** Clayton Christensen's original telling appears in "Competing Against Luck" and his [famous HBS talk](https://www.youtube.com/watch?v=Stc0beAxavY).
