---
title: Analyze All Four Forces, Not Just Push and Pull
impact: CRITICAL
tags: four-forces, analysis, friction
---

## Analyze All Four Forces, Not Just Push and Pull

Most teams only analyze why customers want to switch (Push + Pull). They ignore what's stopping them (Anxiety + Habit). This is why features that "should" win don't.

**Incorrect (only Push and Pull):**

> **Analysis for new CRM:**
> - Push: Current CRM is slow, missing features, bad mobile app
> - Pull: Our CRM is faster, has better analytics, great mobile experience
>
> **Conclusion:** We should win on features!

Six months later: "Why aren't they switching? We're clearly better!"

**Correct (all four forces):**

> **Analysis for new CRM:**
> - **Push:** Current CRM is slow, missing features, bad mobile app
> - **Pull:** Our CRM is faster, has better analytics, great mobile experience
> - **Anxiety:** "What if the migration breaks our data?" "What if my team can't learn it?" "What if it doesn't integrate with our other tools?"
> - **Habit:** Team has 3 years of muscle memory with current tool. Custom workflows built around its quirks. "Good enough" for daily work.
>
> **Conclusion:** Features alone won't win. We need to reduce anxiety (free migration service, integration guarantees) and break habits (show immediate value on Day 1, don't require full commitment).

**Why it matters:**

Push + Pull must exceed Anxiety + Habit for change to happen. If you only amplify Pull, you're fighting with one hand tied. Often, *reducing friction* (Anxiety + Habit) is easier and more effective than adding features (Pull).
