---
title: Reduce Friction Instead of Adding Features
impact: HIGH
tags: four-forces, strategy, product
---

## Reduce Friction Instead of Adding Features

When customers aren't buying, the instinct is to add more features (increase Pull). Often, it's more effective to reduce Anxiety and Habit (the friction forces). You can't out-feature friction.

**Incorrect (adding features to win):**

> **Problem:** Customers evaluating our CRM aren't converting.
>
> **Solution:** Add more features! Better reporting, AI insights, more integrations.
>
> *Result:* Conversion doesn't improve. Customers still say "maybe next quarter."

**Correct (reducing friction):**

> **Problem:** Customers evaluating our CRM aren't converting.
>
> **Friction Analysis:**
> - Anxiety: "What if the migration breaks our data?" "What if the team hates it?"
> - Habit: "We've customized Salesforce for 3 years." "Everyone knows where things are."
>
> **Solution:**
> - Free white-glove migration with rollback guarantee (reduces anxiety)
> - "Run both systems for 30 days" option (reduces anxiety)
> - Import their custom fields and recreate their views (reduces habit friction)
> - Show value in first 10 minutes without full setup (breaks habit of "good enough")
>
> *Result:* Conversion improves because you removed what was actually blocking the decision.

**Why it matters:**

The condo developer who couldn't sell to downsizers didn't add nicer countertops. They included moving services and 2 years of storage — removing the friction of "dealing with 30 years of stuff." Sales increased 30%. Sometimes the blockers have nothing to do with your product.
