# Jobs-to-be-Done (JTBD) Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Insight: Context + Outcome

Most frameworks focus on **pain and gain**. JTBD focuses on **context and outcome**.

The context someone is in determines what they value. The same person in different contexts will "hire" completely different products for the same underlying job.

**Example: Snickers vs. Milky Way**

Both are candy bars. Same aisle. Similar ingredients. But they're hired for completely different jobs:

| Snickers | Milky Way |
|----------|-----------|
| Missed lunch, lots of work, running out of energy | After an emotional experience (positive or negative) |
| Competes with: protein shake, Red Bull, sandwich | Competes with: glass of wine, brownie, going for a run |
| Job: Get back to work fast | Job: Take time to regroup emotionally |

If you only looked at the products, you'd think they compete. If you look at the context, you see they don't.

## The Four Forces of Progress

Change only happens when the forces pushing toward change outweigh the forces resisting it.

```
                    ┌─────────────────┐
     F1: Push      │                 │      F2: Pull
  (current pain)   │   CHANGE        │   (new solution)
       ────────────►│   HAPPENS       │◄────────────
                    │                 │
                    └────────┬────────┘
                             │
              ───────────────┼───────────────
                             │
                    ┌────────┴────────┐
     F3: Anxiety   │                 │      F4: Habit
    (of the new)   │   NO CHANGE     │   (of present)
       ────────────►│                 │◄────────────
                    └─────────────────┘
```

**F1 + F2 must be greater than F3 + F4 for someone to switch.**

### Force 1: Push of the Current Situation
What's making the current situation intolerable? This has nothing to do with your product—it's about their existing pain.

- "My current tool keeps crashing"
- "I missed another deadline"
- "My boss is frustrated with our reporting"

### Force 2: Pull of the New Solution
What's the magnetism of the new? What outcome are they hoping for?

- "I could finally automate this"
- "My team would save 10 hours a week"
- "I'd look competent in front of leadership"

### Force 3: Anxiety of the New
What fears prevent them from switching? Every new product creates anxiety.

- "What if it doesn't work?"
- "What if I can't learn it?"
- "What if my data gets lost in migration?"

### Force 4: Habit of the Present
What keeps them comfortable with the status quo?

- "I know how to use the current tool"
- "My team is already trained on it"
- "It's good enough"

**Key insight: You can drive change by either increasing F1/F2 OR decreasing F3/F4.** Often, reducing friction (F3/F4) is easier than adding features (F2).

**Real example:** A condo developer couldn't sell units to downsizers. The problem wasn't the condo—it was the friction of moving. Solution: Include moving services and 2 years of storage in the price. Sales increased 30%.

## The Three Types of Energy

Every job has three dimensions of energy that motivate action:

### 1. Functional Energy
Time, effort, space, knowledge required.
- "I need to do this faster"
- "I need to do this with less effort"
- "I need to learn how to do this"

### 2. Emotional Energy
How the person feels about themselves.
- "I feel frustrated"
- "I feel overwhelmed"
- "I want to feel confident"

### 3. Social Energy
How others perceive them.
- "My boss thinks I'm incompetent"
- "I want my team to respect me"
- "I need to impress this client"

**All three matter.** A product that saves time (functional) but makes someone feel incompetent (emotional) or look bad to peers (social) won't get hired.

## The Customer Timeline

Customers don't randomly buy. There's a timeline of events leading to purchase:

```
STRUGGLE PHASE          EVALUATION PHASE           GROWTH PHASE
─────────────────────────────────────────────────────────────────────

Problem    →    Interest    →    First Value    →    Value         →    Expansion
(trigger)       (shopping)       (activation)       Realization        (habit)
```

### 1. First Thought
Something happens that plants a seed. They're not shopping yet, but the status quo cracks.

### 2. Passive Looking
They're problem-aware but solution-unaware. Reading articles, asking peers, noticing ads they ignored before.

### 3. Active Looking
Now they're comparing solutions. On your website, competitors' sites, reading reviews.

### 4. Deciding
Making trade-offs. What matters most? What can they live without?

### 5. First Use
The critical moment. Does reality match expectations?

### 6. Ongoing Use
Building the new habit. If this breaks down, they churn.

**Key insight:** Your sales/marketing process should match where the customer is in their timeline, not where you want them to be.

## How to Do JTBD Research

### Who to Interview

Interview customers who:
- **Recently purchased** (within 3-6 months) — they remember what life was like before
- **Are happy and paying** — you want to understand success
- **Chose your product** over alternatives — they made an active decision

Don't interview:
- Customers from 2+ years ago (they'll fabricate memories)
- People who "want to" buy but haven't (they can't assure future behavior)
- Users who were assigned your product (no choice = no job insight)

**"Bitching ain't switching."** Just because people complain doesn't mean they'll change. Only interview people who actually changed.

### How Many Interviews

**10-12 interviews, no more.** Patterns emerge at 7-8 interviews. Two rounds of 12 is better than one round of 24.

You're not doing statistical research. You're finding causal mechanisms. If you understand the range of your market, you can sample deliberately.

### The Interview Approach

**Don't use a discussion guide.** A rigid script prevents you from following the most meaningful threads.

Instead, use the Four Forces as your mental framework and let the conversation unfold naturally.

**Your goal:** Reconstruct the story of how they decided. Get them to tell you what happened, not what they think you want to hear.

**Key techniques:**

1. **Get past the pablum layer**
   - First answers are generic: "It was easy" "I got a deal"
   - Push deeper: "Tell me more about that. What do you mean by easy?"

2. **Get past the fantasy/nightmare layer**
   - Second answers are exaggerated: "It was amazing!" or "It was terrible!"
   - Ground them in specifics: "Walk me through exactly what happened"

3. **Play things back incorrectly**
   - "So you bought it because of the price?" (when you know it wasn't)
   - They'll correct you and elaborate on the real reason

4. **Bracket when they run out of language**
   - "Was it more about X or more about Y?"
   - You know neither is right—it forces them to articulate

5. **Follow the irrational**
   - When something seems crazy, you're missing context
   - "Why would someone cut off their arm?" makes sense in certain contexts
   - The irrational reveals the real job

### Questions to Explore

**About the Push (F1):**
- "What was going on in your life when you started looking for a solution?"
- "What was the moment that made you say 'I have to do something about this'?"
- "What had you tried before that didn't work?"

**About the Pull (F2):**
- "What were you hoping would be different?"
- "When you imagined life with a new solution, what did that look like?"
- "What was the outcome you were trying to achieve?"

**About Anxiety (F3):**
- "What concerns did you have about switching?"
- "What almost stopped you from buying?"
- "What did you need to believe before you could commit?"

**About Habit (F4):**
- "What did you have to give up to make this work?"
- "Who else did you need to convince?"
- "What made the old way comfortable despite its problems?"

**About the Decision:**
- "Walk me through the moment you decided this was the one"
- "What was the tipping point?"
- "What would have made you choose differently?"

## Synthesizing What You Learn

### Cluster, Don't Segment

Don't look for themes across all interviews. Look for **pathways**—sets of pushes, pulls, anxieties, and habits that work together.

You'll typically find 3-5 distinct jobs for any product. These jobs may conflict with each other.

### The Job Statement Format

```
When I am [SITUATION/CONTEXT],
help me [MOTIVATION/WHAT I'M TRYING TO DO],
so I can [DESIRED OUTCOME].
```

**Example (SparkToro):**
- When I am **struggling to identify marketing opportunities that aren't obvious**
- Help me **discover audiences and influences in a way that's organized and shareable**
- So I can **drive better results and look like a pro to stakeholders**

### Prioritizing Jobs

If you find multiple jobs, prioritize based on:

| Criteria | Why It Matters |
|----------|---------------|
| High willingness to pay | They see clear value |
| Urgent problem | Painkiller, not vitamin |
| Low handholding needed | Easier to serve profitably |
| High retention potential | Long-term customer value |
| Easy to reach | You can actually market to them |
| Your unfair advantage | You can win against competitors |

**Start with one job.** Nail it. Then expand to others.

## Common Mistakes

### 1. Doing JTBD in a conference room
You will be 100% wrong if you hypothesize jobs without talking to customers. The irrational, contextual insights only come from real interviews.

### 2. Focusing on outcomes without context
"Customers want to save time" is useless. **Which** customers, in **what** context, want to save time on **what**, and **why now**?

### 3. Interviewing people who "want to" buy
Future intentions are unreliable. Only interview people who already made a decision and took action.

### 4. Following your best users into complexity
Your power users will ask for features that destroy what makes you valuable to new users. The job that got you here may not be the job that scales.

### 5. Treating complaints as jobs
"Bitching ain't switching." Complaints tell you what's annoying, not what will drive change.

### 6. Asking customers what they want
They don't know. They'll tell you granite countertops, but buy the finished basement. Study what they **did**, not what they **say** they'd do.

## Applying JTBD: A Checklist

### For Product Development
- [ ] What job are we hiring this feature to do?
- [ ] What's the push that makes customers need this?
- [ ] What anxiety might prevent adoption?
- [ ] What habit does this feature need to replace?
- [ ] How do we reduce friction, not just add features?

### For Positioning & Messaging
- [ ] What context triggers our customer to look for a solution?
- [ ] What's the desired outcome in their words (not ours)?
- [ ] Who do they see as our real competition (not category competitors)?
- [ ] What anxiety can we address directly in our messaging?

### For Sales
- [ ] Where is this customer in their buying timeline?
- [ ] What do they need to learn at this stage?
- [ ] What anxieties do we need to reduce?
- [ ] What habits are they leaving behind?

### For Churn Analysis
- [ ] What job did churned customers hire us for?
- [ ] Did we fail to deliver on that job?
- [ ] Did their context change (making the job irrelevant)?
- [ ] What did they hire instead of us?

## Quick Reference

**The core idea:** People hire products to make progress. Understand the progress, not just the product.

**The Four Forces:** Push + Pull must exceed Anxiety + Habit for change to happen.

**Who to interview:** Recent purchasers (3-6 months) who made an active choice and are happy.

**How many:** 10-12 interviews. Patterns emerge at 7-8.

**What to find:** The context they were in, the outcome they wanted, the anxieties they overcame, and the habits they broke.

**How to use it:** Cluster into jobs, prioritize one, align your product/marketing/sales to serve that job.

---

