---
name: monetizing-innovation
description: Use when asked about "pricing strategy", "willingness to pay", "value metric", "packaging tiers", "good better best pricing", "subscription vs usage pricing", or "price before product". Helps design products customers will pay for and choose pricing models that capture value. Based on Madhavan Ramanujam's Monetizing Innovation framework from Simon-Kucher.
---

# Monetizing Innovation

## What It Is

Monetizing Innovation is a framework for designing products that customers need, value, AND are willing to pay for. The core insight: **price is not a number you slap on at the end — it's a measure of value that should guide what you build from the start.**

The key shift: Move from "build the product, then figure out pricing" to "understand willingness to pay, then design the product around it."

72% of innovations fail from a monetization perspective — not because the product is bad, but because companies never validated that customers would actually pay for it.

**Credit:** This framework is based on *Monetizing Innovation* by Madhavan Ramanujam and Georg Tacke of Simon-Kucher & Partners, the world's leading pricing strategy consulting firm.

## When to Use It

Use Monetizing Innovation when you need to:

- **Validate product ideas** before investing engineering resources
- **Prioritize your roadmap** based on what drives willingness to pay
- **Choose a pricing model** (subscription, usage, hybrid, outcome-based)
- **Design packaging tiers** (good/better/best) that convert
- **Increase revenue** without building new features
- **Avoid leaving money on the table** or underpricing
- **Prepare for price negotiations** in B2B sales
- **Navigate pricing in a downturn** without destroying value

## When Not to Use It

- **Commoditized markets** where you have no pricing power
- **Regulated pricing** environments (healthcare, utilities)
- **Very early discovery** — you need a product concept to test willingness to pay against
- **Consumer products with pure network effects** where monetization must wait (though even then, understand your future model)

## Patterns

Detailed examples showing how to apply Monetizing Innovation correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [pricing-after-building](patterns/pricing-after-building.md) | Have willingness to pay conversations BEFORE building, not after |
| [asking-what-to-charge](patterns/asking-what-to-charge.md) | Never ask "what should I charge?" — use relative and indirect methods |
| [wrong-value-metric](patterns/wrong-value-metric.md) | The metric you charge on determines everything — get it right |
| [giving-farm-away](patterns/giving-farm-away.md) | 20% of features drive 80% of willingness to pay — don't give them away free |
| [one-size-fits-none](patterns/one-size-fits-none.md) | Segment by needs and willingness to pay, not demographics |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [features-not-benefits](patterns/features-not-benefits.md) | Pitch benefits (what customers get) not features (what you built) |
| [cost-plus-pricing](patterns/cost-plus-pricing.md) | Price based on customer value, not your costs |
| [discounting-to-close](patterns/discounting-to-close.md) | Trade value for discounts — never give without getting |
| [land-without-expand](patterns/land-without-expand.md) | Design your land offer so there's room to expand |
| [ignoring-thresholds](patterns/ignoring-thresholds.md) | Psychological price thresholds exist — find and respect them |
| [rushing-pricing-model](patterns/rushing-pricing-model.md) | How you charge matters more than how much — choose deliberately |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [missing-decoy](patterns/missing-decoy.md) | Use behavioral pricing (decoys, anchoring, compromise effect) |
| [static-segmentation](patterns/static-segmentation.md) | Customers change segments — capture value dynamically |
| [poc-without-commitment](patterns/poc-without-commitment.md) | POCs should build business cases, not just test features |


## Deep Dives

Read only when you need extra detail.

- `references/monetizing-innovation-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Monetizing Innovation* by Madhavan Ramanujam & Georg Tacke — the foundational framework
- *Scaling Innovation* by Madhavan Ramanujam — sequel on acquisition, monetization, retention
- *Confessions of the Pricing Man* by Hermann Simon — founder of Simon-Kucher's lessons

**Other:**
- *Predictably Irrational* by Dan Ariely — behavioral economics foundations
- Kyle Poyar / OpenView — PLG pricing research and guides
- First Round Review pricing content — case studies and frameworks
