---
title: Price Based on Value, Not Costs
impact: HIGH
tags: pricing, value, margins
---

## Price Based on Value, Not Costs

Cost-plus pricing (adding a margin to your costs) ignores what customers are willing to pay. You might charge too little and leave money on the table, or charge too much for something customers don't value. Customer value should determine price.

**Incorrect (cost-plus thinking):**

> Finance team calculates:
> - Server costs: $2/user/month
> - Support costs: $3/user/month
> - Development amortization: $5/user/month
> - Total cost: $10/user/month
>
> "We need 40% margins, so price should be $14/user/month."
>
> They launch at $14. Adoption is slow. Meanwhile, a competitor charges $39/user for a similar product and is growing faster.
>
> Why? The competitor's product saves customers 10 hours per month. At $50/hour labor cost, that's $500 in value. $39 is a bargain for $500 in value. The $14 product felt cheap and therefore suspect.

**Correct (value-based pricing):**

> Team conducts willingness to pay research:
>
> "Our tool saves an average of 10 hours/month per user. At your labor costs, what's that worth?"
>
> Customers: "Probably $400-600/month in saved time, plus avoiding missed deadlines which cost us even more."
>
> "What would be an acceptable price? Expensive? Prohibitively expensive?"
>
> Results cluster: Acceptable $29, Expensive $49, Prohibitive $79
>
> Team prices at $39/user/month — in the "expensive but fair" zone. Margins are 280% instead of 40%, and customers see it as reasonably priced for the value delivered.
>
> The ROI story: "You're paying $39 to save $500. That's 12x return."

**Why it matters:**

Your costs are irrelevant to customers. They care about the value they receive. Price should be a share of the value you create, not a markup on what you spend. In SaaS, capturing 10-20% of value delivered is typical. In outcome-based AI pricing, 25-50% is achievable.
