---
title: Never Discount Without Getting Something Back
impact: HIGH
tags: negotiation, discounting, b2b-sales
---

## Never Discount Without Getting Something Back

When you give a discount without asking for something in return, you signal that your pricing has slack in it. The customer learns they can push harder, and your "discount" becomes the new expected price. Always trade value for value.

**Incorrect (giving discounts freely):**

> Sales rep on a deal:
>
> Prospect: "Your price is $100K but we only have $80K budget."
> Sales: "Let me see what I can do... okay, I can get you $85K."
> Prospect: "That's still over budget. Can you do $80K?"
> Sales: "I really shouldn't, but... okay, $80K."
> Prospect: "Great, but we also need to push payment to net-60."
> Sales: "Fine, we'll make it work."
>
> Result: Sold at 20% discount with worse terms. At renewal, customer expects the same price. Sales just established that list price is fictional.

**Correct (gives and gets):**

> Sales rep on the same deal:
>
> Prospect: "Your price is $100K but we only have $80K budget."
> Sales: "I understand budget constraints. If I could get to $85K, would you be able to commit to a 2-year term instead of 1-year?"
> Prospect: "Maybe. Can you do $80K?"
> Sales: "At $80K, I'd need the 2-year commitment plus a case study we could publish. You'd also need to participate in quarterly value audits so we can document ROI together."
> Prospect: "The case study might work. What's a value audit?"
> Sales: "Every quarter, your team tracks the value we're delivering. It helps you justify the investment internally and helps us improve the product. At renewal, you'll have your own data showing the ROI."
>
> Result: Sold at $80K but with 2-year commitment, case study rights, and a value audit process that makes renewal 80% more likely.

**Why it matters:**

Every discount without a get trains customers that your prices are negotiable and inflated. Gets like value audits, longer terms, reference rights, and faster payments have real business value. The customer feels they earned the discount. You protected your pricing integrity and gained strategic assets.
