---
title: Find and Respect Psychological Price Thresholds
impact: HIGH
tags: behavioral-pricing, thresholds, psychology
---

## Find and Respect Psychological Price Thresholds

Demand curves aren't smooth — they have cliffs. Crossing from $99 to $101 might lose you 30% of potential customers, even though it's just $2. These psychological thresholds are real and measurable. Find them before setting your price.

**Incorrect (ignoring thresholds):**

> Team prices their SaaS product based on spreadsheet modeling:
>
> "At $105/month, we hit our margin targets with projected volume."
>
> They launch at $105. Conversion is 40% below projections.
>
> Later research reveals: At $99, 70% said "acceptable" or "expensive" (would buy). At $105, that dropped to 45% — a cliff at the $100 threshold. The $6 difference cost them 25% of their market.

**Correct (threshold-aware pricing):**

> Before setting price, team runs acceptable/expensive/prohibitive questions:
>
> "What price would be acceptable?" (clustered: $75-90)
> "What price would be expensive?" (clustered: $95-120)
> "What price would be prohibitively expensive?" (clustered: $140+)
>
> They notice a sharp drop at $100 — 30% fewer respondents stay in the "would buy" range above $100 vs. below.
>
> Decision: Price at $99/month. It's in the "expensive but fair" range (good margin) while staying below the psychological threshold.
>
> For customers who need more features, they create a $149 tier — deliberately jumping OVER the $100-120 dead zone to the next stable threshold.

**Why it matters:**

These thresholds exist whether you measure them or not. $29.99 vs $30. $99 vs $101. $999 vs $1,000. They're cultural, psychological, and real. A few dollars of "optimization" across a threshold can cost you 20-30% of conversions. Always test for thresholds in your specific market.
