---
title: Design Your Land Offer So There's Room to Expand
impact: HIGH
tags: land-expand, packaging, growth
---

## Design Your Land Offer So There's Room to Expand

90% of companies that claim to have a "land and expand" strategy are only landing. They give away so much in the initial sale that there's nothing meaningful left to expand to. Design the land deliberately so expansion is natural.

**Incorrect (landing with nowhere to expand):**

> Company sells an AI writing tool:
>
> **Land deal:** Enterprise license, unlimited users, all features, $50K/year
>
> Year 1: Customer uses it extensively. Happy.
> Year 2 renewal: Sales tries to upsell.
>
> Customer: "Upsell to what? We already have unlimited everything."
> Sales: "We have new features..."
> Customer: "That should be included in what we're already paying."
>
> Result: Flat or declining revenue per customer. No expansion path. Sales becomes a renewal/retention motion, not a growth motion.

**Correct (land with expansion built in):**

> Revised approach:
>
> **Land deal:** Team license, 25 seats, core features, $30K/year
> - Per-seat overage pricing if they exceed 25
> - Advanced features (API, custom models, analytics) available as add-ons
> - Enterprise tier with unlimited seats, SSO, and admin controls
>
> Year 1: Customer starts with 25 seats. By month 8, they're at 35 seats (overage charges).
> Year 2 renewal:
>
> Sales: "You're now at 45 active users and paying overage fees. Let me show you our Team Plus tier at 50 seats plus the analytics add-on. It's better economics and you get features your power users have been requesting."
>
> Customer: "That makes sense. What about the Enterprise tier?"
>
> Result: 40% expansion at renewal. Clear path to 3x initial deal over 3 years.

**Why it matters:**

The land should be a wedge, not the whole pie. Seed it with natural expansion triggers: seat limits, usage caps, feature gates. If customers max out immediately, you've priced wrong. If there's never pressure to expand, you've packaged wrong.
