---
title: Use Behavioral Pricing Strategically
impact: MEDIUM
tags: behavioral-pricing, decoy, anchoring
---

## Use Behavioral Pricing Strategically

People are irrational but predictably so. Behavioral pricing tactics like decoys, anchoring, and the compromise effect can significantly shift which package customers choose — without changing what you offer.

**Incorrect (ignoring behavioral dynamics):**

> SaaS company launches three tiers:
>
> - Basic: $49/month
> - Pro: $79/month
> - Enterprise: $149/month
>
> Result: 65% choose Basic, 25% choose Pro, 10% choose Enterprise.
>
> Team: "We need better features in Pro to get people to upgrade."
>
> They add features. Distribution barely changes. The problem isn't the features — it's the psychology. Basic feels like a "good deal" and there's no pressure to move up.

**Correct (using decoy and compromise effects):**

> Revised pricing architecture:
>
> - Basic: $49/month (slightly reduced features)
> - Pro: $99/month (same features as before)
> - Enterprise: $199/month (same features)
> - **Custom: $299/month** (new decoy tier with marginal additions)
>
> Changes made:
> 1. Basic was de-featured slightly (can't give the farm away)
> 2. Pro moved from $79 to $99 (research showed no threshold until $120)
> 3. Added $299 "Custom" tier as a decoy to make $199 look reasonable
>
> Result: 35% Basic, 40% Pro, 20% Enterprise, 5% Custom
>
> MRR increased 32% with the same product. The compromise effect pushed people toward the middle (Pro), and the decoy made Enterprise feel like the smart premium choice.

**Why it matters:**

If 60%+ of customers are in your lowest tier, you've likely given away too much value there AND failed to make middle tiers feel like the obvious choice. Behavioral tactics aren't manipulation — they're presenting options in a way that helps customers make decisions aligned with their needs.
