---
title: One Size Fits None — Segment by Willingness to Pay
impact: CRITICAL
tags: segmentation, packaging, personas
---

## One Size Fits None — Segment by Willingness to Pay

Segmentation isn't about demographics or personas — it's about different needs and different willingness to pay. If you can't act differently (build different products, charge different prices) for each segment, it's not real segmentation.

**Incorrect (demographic personas):**

> Marketing defines three personas:
> - "Startup Steve" — 25-35, tech-savvy, growth-focused
> - "Enterprise Emma" — 40-50, risk-averse, process-oriented
> - "SMB Sam" — 30-40, budget-conscious, time-strapped
>
> Product builds one product, then asks marketing to "position it differently" for each persona.
>
> Result: Same landing page copy tweaked three ways, but everyone sees the same $49/month pricing. Enterprise Emma won't pay $49 — too cheap to seem serious. Startup Steve can't justify $49 — too expensive for their stage. SMB Sam might pay $49 but needs a different feature set entirely.
>
> Classic example: Charles and Ozzy Osbourne are both 70+, live in castles, are wealthy, and British. Same demographics, wildly different needs and willingness to pay.

**Correct (needs and WTP segmentation):**

> Research reveals three distinct segments based on needs and willingness to pay:
>
> Segment A: Needs basic functionality, willing to pay $15-25/month
> - Build: Streamlined product, self-serve onboarding
> - Price: $19/month
>
> Segment B: Needs integrations + team features, willing to pay $50-100/month
> - Build: Integration marketplace, collaboration tools
> - Price: $79/month with per-seat pricing
>
> Segment C: Needs custom workflows + compliance, willing to pay $200-500/month
> - Build: Custom workflow builder, audit logs, SSO
> - Price: $299/month + implementation fee
>
> Result: Three products for three willingness-to-pay segments. Each feels appropriately priced for what they get. Total revenue 3x higher than one-size-fits-all approach.

**Why it matters:**

The three most important words in segmentation are "you act differently." If you're not building different products or packages for different segments, you're just doing marketing positioning — and leaving money on the table with every customer.
