---
title: Have Willingness to Pay Conversations Before Building
impact: CRITICAL
tags: timing, validation, willingness-to-pay
---

## Have Willingness to Pay Conversations Before Building

72% of innovations fail from a monetization perspective because pricing conversations happen too late. By the time you've built the product, you've lost the ability to pivot.

**Incorrect (pricing as an afterthought):**

> Product team completes 18 months of development on a new analytics dashboard. Two weeks before launch, they bring in the pricing team.
>
> "What should we charge for this?"
>
> Sales: "Customers said they loved the demos."
> Finance: "Based on our costs, we need $50/user/month to hit margins."
>
> They launch at $50/user. Six months later, adoption is 30% of projections. Customers liked the demos but won't pay — they already have "good enough" solutions.

**Correct (price before product):**

> Product team has an idea for an analytics dashboard. Before writing any code, they run 25 customer conversations.
>
> "We're thinking about building a dashboard that shows X, Y, Z. On a scale of 1-5, how likely would you be to buy this?"
>
> Result: Most say 3 or below (meaning they won't buy). Digging into "why," they learn the real problem isn't visualization — it's data integration.
>
> The team pivots to build an integration-first product. In follow-up conversations, purchase probability jumps to 4-5. They build that product instead.

**Why it matters:**

You can't change direction after 18 months of development. Having willingness to pay conversations before building lets you discover — before it's too late — whether customers will actually pay, what they'll pay for, and what price points feel right.
