---
title: Choose Your Pricing Model Deliberately
impact: HIGH
tags: pricing-model, subscription, usage-based
---

## Choose Your Pricing Model Deliberately

Teams often pick whatever pricing model is trendy (usage-based because Snowflake did it, subscription because SaaS does it) without analyzing whether it fits their business. How you charge matters more than how much.

**Incorrect (following trends):**

> Startup building a design collaboration tool:
>
> "Usage-based pricing is the future. Snowflake does it. Let's charge per design exported."
>
> Launch: $0.50 per export
>
> Problems:
> - Customers can't predict their bills
> - Heavy users feel punished for being engaged
> - Light users don't generate enough revenue to justify support costs
> - Finance can't forecast revenue
>
> Result: Complaints about unpredictable pricing, high churn from power users, low revenue from casual users.

**Correct (model fits business dynamics):**

> Team analyzes their business:
>
> Subscription indicators:
> - Customers want predictable budgets (yes)
> - Usage is relatively consistent month-over-month (yes)
> - Value is ongoing even when not actively using (yes — files stay organized)
>
> Usage indicators:
> - High usage variability (no)
> - Customers demand pay-for-what-you-use fairness (some)
>
> Decision: Hybrid model
> - Base subscription: $15/seat/month (covers core value)
> - Export overage: First 100 exports free, then $0.10 each (captures heavy usage)
>
> Result: Predictable revenue, light users find it affordable, heavy users pay more but feel it's fair because base price is low.

**Why it matters:**

Michelin didn't switch to per-mile pricing because it was trendy — they did it because truckers' economics worked better with variable costs. Choose your model based on how your customers experience value and manage budgets, not based on what other companies do.
