---
title: Capture Value Dynamically as Context Changes
impact: MEDIUM
tags: segmentation, personalization, dynamic-pricing
---

## Capture Value Dynamically as Context Changes

Customers don't stay in one segment forever. The same person ordering lunch on Tuesday has different needs than ordering dinner on Friday. Static segmentation misses revenue from context changes.

**Incorrect (static segment assignment):**

> Food delivery app segments users at signup:
>
> - "Budget Shopper" → always shown budget options
> - "Convenience Seeker" → always shown fast delivery
> - "Foodie" → always shown top-rated restaurants
>
> Problem: The "Budget Shopper" has a birthday dinner to plan and would pay premium for a special restaurant. The "Foodie" is ordering lunch at work and just wants something fast and cheap.
>
> Result: Missed upsell opportunities and frustrated users who feel boxed into a category.

**Correct (dynamic context-based pricing):**

> Same app uses behavioral signals:
>
> Signals tracked:
> - Time of day / day of week
> - Order history and frequency
> - Cart size and item types
> - Delivery urgency
>
> Dynamic responses:
> - Tuesday 12:30 PM → surface quick lunch deals, highlight fast delivery
> - Friday 7 PM → surface premium restaurants, offer scheduled delivery
> - Same user placing third order this week → loyalty discount offer
> - Large cart with premium items → premium delivery options highlighted
>
> Result: Same user sees different pricing and options based on context. Revenue per order increases 15% because offers match the moment.

**Why it matters:**

People aren't static — they move between segments based on context, mood, budget, and occasion. Modern technology allows real-time segmentation. Companies still using static segments are leaving money on the table with every transaction.
