---
title: Choose Your Value Metric Carefully
impact: CRITICAL
tags: pricing-model, value-metric, monetization
---

## Choose Your Value Metric Carefully

How you charge (the value metric) matters more than how much you charge. The wrong metric creates friction, feels unfair, or leaves money on the table. The right metric scales naturally with customer value.

**Incorrect (internal technical metric):**

> Segment originally priced per API call. Their pricing page listed complex tiers:
> - 10K API calls: $50/month
> - 100K API calls: $200/month
> - 1M API calls: $1,000/month
>
> Problems:
> - Marketing buyers didn't understand what an "API call" was
> - Customers couldn't predict their usage or costs
> - Heavy users felt penalized even when Segment wasn't providing proportional value
>
> Result: Constant pricing complaints, unpredictable revenue, and lost enterprise deals.

**Correct (customer-value-aligned metric):**

> Segment switched to "monthly tracked users" (MTU):
> - 10K MTU: $120/month
> - 50K MTU: $500/month
> - 100K MTU: $900/month
>
> Why it works:
> - Marketing buyers understand users — it's their core metric
> - More users = bigger business = they can afford to pay more
> - Costs feel fair and predictable
> - Natural expansion as customers grow
>
> Result: Enterprise deals closed faster, retention improved, and expansion revenue doubled.

**Why it matters:**

The value metric affects acquisition (different sizes pay different amounts), retention (customers downgrade instead of canceling), and expansion (growth is automatic, not a resell). Get it wrong and everything downstream suffers.
