---
name: okrs
description: Use when asked to "set OKRs", "objectives and key results", "quarterly OKR planning", "align objectives", "measure OKR progress", or "focus priorities with OKRs". Helps teams focus on what matters most and create a cadence of progress. The OKR framework (originated by Andy Grove at Intel, popularized by John Doerr at Google) creates alignment, focus, and learning cycles. Christina Wodtke's Radical Focus approach emphasizes simplicity and avoiding common pitfalls.
---

# OKRs (Objectives and Key Results)

## What It Is

OKRs are a goal-setting framework that creates focus, alignment, and a learning cycle for teams and organizations. The core insight: **set one ambitious objective per quarter with 2-3 measurable key results, then check in weekly to maintain focus.**

The key shift: Move from tracking activities ("What are we doing?") to tracking outcomes ("What progress are we making toward our goals?").

OKRs are a vitamin, not a medicine. They supercharge companies that already have their fundamentals in place (strategy, empowered teams, psychological safety). They won't fix broken organizations - they'll just reveal what's broken.

**Credit:** Originated by Andy Grove at Intel. Popularized by John Doerr who brought it to Google. Christina Wodtke's *Radical Focus* provides the most practical implementation guidance.

## When to Use It

Use OKRs when you need to:

- **Focus the team** on the single most important thing for the quarter
- **Align the organization** so everyone knows what matters most
- **Create accountability** with measurable outcomes (not just activities)
- **Build a learning cycle** through weekly check-ins and quarterly retrospectives
- **Scale leadership** so founders/executives don't need to micromanage
- **Accelerate progress** by avoiding the "peanut butter" problem of spreading effort too thin

## When Not to Use It

- You don't have a clear strategy (OKRs reveal missing strategy, they don't replace it)
- Your company lacks psychological safety (people will sandbag or game the metrics)
- You want to track ALL the work (OKRs are for priorities, not comprehensive task lists)
- Teams aren't empowered to decide HOW to achieve outcomes

## Patterns

Detailed examples showing how to apply OKRs correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [key-results-are-tasks](patterns/key-results-are-tasks.md) | Key results must be outcomes, not activities or deliverables |
| [too-many-okrs](patterns/too-many-okrs.md) | One objective per quarter — not five, not ten |
| [missing-strategy](patterns/missing-strategy.md) | OKRs without strategy is just goal theater |
| [boring-objectives](patterns/boring-objectives.md) | Objectives should make you want to get out of bed |
| [no-weekly-checkins](patterns/no-weekly-checkins.md) | Set and forget kills OKRs — the cadence is the system |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [sandbagging-goals](patterns/sandbagging-goals.md) | Goals should make you uncomfortable but not doomed |
| [fluffy-objectives](patterns/fluffy-objectives.md) | Vague objectives like "improve quality" mean nothing |
| [grading-without-learning](patterns/grading-without-learning.md) | The retrospective matters more than the score |
| [slow-approval-process](patterns/slow-approval-process.md) | Approval cycles that eat weeks defeat the purpose |
| [okrs-for-everything](patterns/okrs-for-everything.md) | Keep-the-lights-on work doesn't belong in OKRs |
| [cascading-trap](patterns/cascading-trap.md) | Alignment doesn't mean every team mirrors company OKRs |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [skipping-celebrations](patterns/skipping-celebrations.md) | Friday celebrations build momentum and morale |
| [perfect-measurement](patterns/perfect-measurement.md) | Don't let measurement precision block progress |
| [annual-okrs](patterns/annual-okrs.md) | Quarterly is the sweet spot for most teams |


## Deep Dives

Read only when you need extra detail.

- `references/okrs-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Radical Focus* (2nd Edition) by Christina Wodtke — the practical guide
- *Measure What Matters* by John Doerr — the Google story
- *High Output Management* by Andy Grove — where it all started

**Related frameworks:**
- *The Fearless Organization* by Amy Edmondson — psychological safety (required for honest OKR updates)
- *Five Dysfunctions of a Team* by Patrick Lencioni — fixing team issues that block OKR success

**Articles:**
- Christina Wodtke's eleganthack.com — ongoing OKR insights
