---
title: Alignment Doesn't Mean Every Team Mirrors Company OKRs
impact: HIGH
tags: alignment, cascading, autonomy
---

## Alignment Doesn't Mean Every Team Mirrors Company OKRs

A common mistake is making every team's OKRs a subset of the company OKR, creating a cascade that removes all team autonomy. Alignment means contributing to company goals, not copying them word-for-word.

**Incorrect (forced cascade):**

> **Company OKR:** Increase revenue 50%
>
> **Sales Team OKR:** Increase revenue 50%
> **Marketing Team OKR:** Increase revenue 50%
> **Product Team OKR:** Increase revenue 50%
> **Engineering Team OKR:** Increase revenue 50%
>
> Every team has the same goal with no context for HOW they contribute uniquely.

**Correct (aligned but distinct):**

> **Company OKR:** Become the market leader in our category
>
> **Sales Team OKR:** Build a repeatable enterprise sales motion
> - KR: Close 10 enterprise accounts over $100K
> - KR: Reduce sales cycle from 90 to 60 days
> - KR: Win rate on competitive deals reaches 40%
>
> **Product Team OKR:** Make our product impossible to replace once adopted
> - KR: Increase 6-month retention from 70% to 85%
> - KR: Power users create 5+ integrations on average
> - KR: Switching cost (measured by data invested) increases 3x
>
> **Engineering Team OKR:** Build the fastest, most reliable platform in the category
> - KR: Page load time under 500ms at p95
> - KR: Zero customer-impacting outages
> - KR: API response time beats top 3 competitors

Each team contributes to "market leader" through their unique capabilities. They're aligned without being copies.

**Why it matters:**

Rigid cascading removes the autonomy that makes OKRs work. Teams know their domain best. Let them figure out how they contribute. The question isn't "Does your OKR look like mine?" but "Does achieving your OKR help achieve ours?"
