# OKRs (Objectives and Key Results) Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Core Distinction: Objectives vs. Key Results

### Objectives: The Qualitative "What"

An objective is the **inspiring goal** you're driving toward. It answers: "What are we trying to achieve this quarter?"

**Good objectives are:**
- **Qualitative** — words, not numbers
- **Inspiring** — makes you want to get out of bed
- **Time-bound** — achievable within a quarter
- **Clear enough** that you know when you've achieved it

**Examples:**
- "Launch a product users love and we're proud of"
- "Create a profile system that reveals our users' passions"
- "Become the go-to resource for first-time managers"

**Not objectives:**
- "Increase revenue 20%" (that's a key result)
- "Ship the new dashboard" (that's a task)
- "Be excellent" (too vague to act on)

### Key Results: The Quantitative "How Do We Know?"

Key results answer: **"How do we know we succeeded?"**

**Good key results are:**
- **Measurable** — a number you can track
- **Outcomes** — what changed in the world, not what you did
- **Limited** — aim for 3 key results per objective
- **Ambitious** — hitting 70% should feel like success

**The three types to consider:**
1. **Hard metrics** — revenue, users, conversion rates
2. **Quality signals** — NPS, retention, customer satisfaction
3. **Business impact** — something with a dollar sign

**Example objective with key results:**
```
Objective: Create a profile system that reveals our users' passions

Key Results:
1. 30% of users create a profile (reach)
2. Weekly active users like 3+ products per week (engagement)
3. Customer panel rates experience 8+ satisfaction (quality)
```

### The "How Do We Know?" Question

When you have an objective, ask: **"How would we know we succeeded?"**

Spend 10 minutes brainstorming every possible way to measure success. The obvious metrics come first, but the interesting ones emerge when you run out of ideas and sit with it longer.

## The OKR Cadence

OKRs create power through rhythm. The cadence IS the system.

```
QUARTERLY                          WEEKLY                           QUARTERLY
─────────────────────────────────────────────────────────────────────────────────

Set OKRs    →    Monday Commits    →    Friday Celebrates    →    Grade & Learn
(last week       (what will I do       (what was awesome         (retrospective
of quarter)      this week?)           this week?)               + next quarter)
```

### Quarterly: Set OKRs

**At the end of each quarter:**
1. Grade the previous quarter's OKRs (see Grading below)
2. Run a retrospective: What worked? What got in our way?
3. Set next quarter's objective and key results
4. Get quick alignment (not prolonged approval cycles)

**Time invested:** Ideally 4-5 days total. Grading second-to-last week, setting OKRs last week.

### Weekly: Monday Commits

Every Monday, answer: **"What am I doing this week to get closer to our goals?"**

Format (keep it short):
- **Confidence level** on each key result (1-5 or percentage)
- **Top 3 priorities** for the week (P1s only — no more than 3)
- **Last week's results** (did we do what we said?)

This can be:
- A Slack message to a channel
- A standup addition
- An email to the team
- A shared doc everyone updates

**The atomic unit of OKRs:** If you can answer "What am I doing this week to move toward our goals?" you have the essence right.

### Weekly: Friday Celebrations

End the week by celebrating wins. This sounds soft but has outsized impact.

Ask: "What was the most awesome thing that happened this week?"
- In marketing?
- In engineering?
- For you personally?

**Why it matters:** People feel part of something special. Morale compounds. Some CEOs have started Friday celebrations before OKRs and reported immediate positive culture change.

### Quarterly: Grade and Learn

**Grading is about learning, not judgment.**

Use a simple scale (don't over-engineer it):
- 0.0 - 0.3: We failed to make progress
- 0.4 - 0.6: We made progress but fell short
- 0.7 - 0.8: We hit the target (this is success!)
- 0.9 - 1.0: We exceeded expectations

**The retrospective matters more than the grade:**
- What got in our way?
- What would we do differently?
- What did we learn about our market/product/team?
- What should we try next quarter?

**Don't get fussy about precision.** "Ah, about 70%" is fine. The learning is what matters.

## The Four Forces of OKR Success

For OKRs to work, you need alignment on these forces:

```
                    ┌─────────────────────┐
     STRATEGY       │                     │      EMPOWERMENT
  (Why this goal?)  │   OKRs WORK         │   (Teams own how)
       ────────────►│                     │◄────────────
                    │                     │
                    └──────────┬──────────┘
                               │
              ─────────────────┼─────────────────
                               │
                    ┌──────────┴──────────┐
     PSYCH SAFETY   │                     │      CADENCE
   (Honest updates) │   OKRs FAIL         │   (Weekly rhythm)
       ────────────►│                     │◄────────────
                    └─────────────────────┘
```

### Strategy: The "Why" Before OKRs

OKRs answer "What are we doing this quarter?" Strategy answers "Why this and not something else?"

If you don't have strategy, OKRs become arbitrary goal-setting. They'll reveal the missing strategy as teams ask "Why this objective?"

**Strategy components:**
- Mission: Why we exist (5-year horizon)
- Strategy: How we'll win (1-year hypothesis)
- OKRs: What we'll do (quarterly focus)

### Empowered Teams: They Own the "How"

OKRs set the destination. Teams decide the route.

If leaders must approve every task, you've created an expensive task-tracking system, not OKRs. The CEO should be thinking about what's coming next, not reviewing IC-level tasks.

### Psychological Safety: Honest Updates

If people fear punishment for missing goals, they'll:
- Sandbag (set easy goals they'll definitely hit)
- Hide problems until it's too late
- Game the metrics

OKRs require honest weekly updates about what's working and what isn't.

### Cadence: The Discipline to Check In

Set and forget doesn't work. The weekly Monday commits + Friday celebrations create retrieval practice - you keep reconnecting with your goals until they're in long-term memory.

## Mission → Strategy → OKRs → Tasks

How OKRs fit in the hierarchy:

```
MISSION          "Why we exist"                    5+ year horizon
    ↓
STRATEGY         "How we'll win"                   1 year hypothesis
    ↓
OKRs             "What we're doing this quarter"   Quarterly focus
    ↓
INITIATIVES      "How we'll achieve our OKRs"      Weekly/monthly work
    ↓
TASKS            "What we're doing today"          Daily work
```

**Example flow:**

| Level | Example |
|-------|---------|
| Mission | "Bring amazing games that delight users and we're proud of" |
| Strategy | "Build on Apple Arcade to establish brand, then expand to other platforms" |
| Q1 Objective | "Create a vision for a game that will drive us forward" |
| Key Results | User testing validates concept; landing page shows interest; tech builds confirm feasibility |
| Initiatives | Run 10 user interviews; build MVP prototype; test core mechanics |
| Tasks | Schedule interviews, design test scenarios, write prototype code |

**The key insight:** Don't confuse levels. Tasks aren't key results. Initiatives aren't objectives.

## How to Set OKRs

### Step 1: Start with Strategy

Before setting OKRs, ask:
- What's our mission for the next 5 years?
- What's our strategy for winning this year?
- Given that strategy, what must happen THIS quarter?

If you can't answer these, you need strategy work, not OKR work.

### Step 2: Draft the Objective

Write an objective that:
- Aligns with your quarterly strategy focus
- Inspires the team
- Is achievable in a quarter (with stretch)

**Test:** Does this make people want to get out of bed? If it's boring, rewrite it.

### Step 3: Ask "How Do We Know?"

Brainstorm all possible ways to measure success:
- What metrics would move?
- What would users do differently?
- What would the business look like?

Spend 10 minutes. The interesting metrics emerge when you run out of obvious ones.

### Step 4: Pick 3 Key Results

Select 3 key results that triangulate success:
1. One hard metric (usage, revenue, conversion)
2. One quality signal (satisfaction, retention, NPS)
3. One that involves money or business impact

### Step 5: Set Ambitious Targets

Set targets that feel uncomfortable but not impossible.

**The 70% rule:** If hitting 70% feels like success, you've set it right. If you're certain you'll hit 100%, you aimed too low. If you're certain you'll fail, you aimed too high.

### Step 6: Get Quick Alignment

Don't let approval processes eat weeks. Try:
- Get 3 peer teams to review (24-hour turnaround)
- Ask: "Does this look right? See any conflicts?"
- Done.

Perfection is the enemy of progress. If you're wrong, you'll learn by end of quarter.

## Piloting OKRs

Don't roll out company-wide on day one.

**Start with your best team:**
1. Pick a high-performing, multidisciplinary team
2. Give them Radical Focus (or this guide)
3. Let them experiment for one quarter
4. Learn what works in YOUR culture

**Why your best team:** They'll figure out where OKRs fit your culture and where they need adaptation. They won't make you hate OKRs before you've really tried them.

**After the pilot:**
- Get their learnings
- Apply to 2-3 more teams
- Iterate
- Eventually roll out to management team
- Scale from there

## Common Mistakes

### 1. Treating Key Results as Tasks
"Ship the new dashboard by March 15" is a task. "30% of users prefer the new dashboard" is a key result. Tasks describe what you'll do; key results describe what will change.

### 2. Too Many OKRs
One objective per quarter. If you have five objectives, you have zero focus. The famous Yahoo "peanut butter memo" described spreading resources so thin that nothing moves.

### 3. No Strategy Underneath
OKRs without strategy is just goal theater. You'll set objectives that don't connect to anything meaningful.

### 4. Set and Forget
OKRs that only come up quarterly are just PowerPoint. The weekly Monday commits and Friday celebrations create the actual change.

### 5. Approval Cycles That Take Weeks
If setting OKRs takes 3 weeks of approvals, you've lost the quarter. Get peer review, move fast, learn from mistakes.

### 6. Sandbagging (Goals Too Easy)
If you always hit 100% of your OKRs, you're not stretching. Ambitious goals are motivating. Easy goals are just paperwork.

### 7. Using OKRs to Track All Work
OKRs are for the big rock you must move. Keep-the-lights-on work still happens - it just doesn't need an OKR.

## Applying OKRs: Checklists

### For Setting OKRs

- [ ] Do we have a clear strategy this OKR supports?
- [ ] Is the objective inspiring (not boring or vague)?
- [ ] Are key results outcomes (not tasks)?
- [ ] Do we have exactly 3 key results (not 7)?
- [ ] Would hitting 70% feel like success?
- [ ] Can the team that owns this OKR actually influence these outcomes?

### For Weekly Check-ins

- [ ] What's our confidence on each key result?
- [ ] What are the TOP 3 priorities this week (not 10)?
- [ ] What did we try last week and what happened?
- [ ] What's blocking progress?
- [ ] What should we try differently?

### For Quarterly Grading

- [ ] Did we learn what works and what doesn't?
- [ ] What got in our way?
- [ ] What would we do differently next time?
- [ ] What should we focus on next quarter given what we learned?
- [ ] Did we capture insights, not just scores?

### For Rolling Out OKRs

- [ ] Did we pilot with our best team first?
- [ ] Did we learn what works in our culture?
- [ ] Did we avoid rolling out company-wide day one?
- [ ] Do we have psychological safety for honest reporting?
- [ ] Are teams empowered to decide how to achieve their OKRs?

## Quick Reference

**The atomic unit:** "What am I doing this week to get closer to our goals?"

**The objective:** Qualitative, inspiring, achievable in a quarter. Makes you want to get out of bed.

**Key results:** 3 measurable outcomes. How do we know we succeeded? Hard metric + quality signal + business impact.

**The cadence:** Monday commits, Friday celebrations, quarterly retrospectives.

**The target:** Hitting 70% feels like success. Uncomfortable but not doomed.

**The lesson:** OKRs are a vitamin, not medicine. They supercharge healthy companies. They reveal dysfunction in broken ones.

---

