---
name: opportunity-solution-trees
description: Use when asked to "opportunity solution tree", "OST", "Teresa Torres", "map customer opportunities to outcomes", "structure discovery around opportunities", or "compare solutions for a customer need". Helps product teams connect outcomes to customer opportunities and test solutions with Opportunity Solution Trees (created by Teresa Torres).
---

# Opportunity Solution Trees

## What It Is

Use the Opportunity Solution Tree (OST) to connect a business outcome to the customer opportunities that drive it, then compare solutions and tests. The tree forces you to separate needs from ideas and keeps discovery tied to delivery.

## When to Use It

- Structure discovery around customer opportunities
- Tie customer needs to measurable outcomes
- Compare multiple solutions for the same opportunity
- Keep continuous discovery aligned with the roadmap
- Create a shared view of priorities with stakeholders

## When Not to Use It

- You are not doing customer research
- The solution is already decided
- The work is a commodity requirement with no real options
- You only need a quick one-off decision

## Patterns

Detailed examples showing how to apply OST correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [opportunities-are-solutions](patterns/opportunities-are-solutions.md) | "Add a search bar" is a solution -- the opportunity is what's hard about finding things |
| [starting-with-solutions](patterns/starting-with-solutions.md) | Work backward from outcomes, not forward from feature ideas |
| [skipping-outcome](patterns/skipping-outcome.md) | Without a clear outcome, you can't evaluate which opportunities matter most |
| [interviewing-for-facts](patterns/interviewing-for-facts.md) | Collect stories, not preferences -- needs emerge from what happened |
| [conference-room-opportunities](patterns/conference-room-opportunities.md) | You can't hypothesize opportunities without customer research |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [single-solution-thinking](patterns/single-solution-thinking.md) | Always compare at least 3 solutions for any opportunity |
| [opportunities-too-big](patterns/opportunities-too-big.md) | "Make it easier to use" is not actionable -- decompose into specific moments |
| [flat-tree-structure](patterns/flat-tree-structure.md) | Opportunities should nest hierarchically from broad to specific |
| [missing-experience-map](patterns/missing-experience-map.md) | Structure opportunities around the customer journey, not internal categories |
| [output-not-outcome](patterns/output-not-outcome.md) | "Launch feature X" is an output -- "Increase activation by 10%" is an outcome |
| [solution-testing-whole-idea](patterns/solution-testing-whole-idea.md) | Break solutions into assumptions and test the riskiest ones first |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [tree-not-updated](patterns/tree-not-updated.md) | The OST is a living document -- update it weekly as you learn |
| [needs-not-heard](patterns/needs-not-heard.md) | Train your ear to hear opportunities customers don't explicitly state |
| [too-many-branches](patterns/too-many-branches.md) | Limit top-level opportunities to 5-7 for cognitive manageability |

## Core Structure (Overview)

- Outcome: the business result you are responsible for achieving
- Opportunities: unmet customer needs, pains, or desires
- Solutions: multiple ideas that address one opportunity
- Experiments: tests that validate the riskiest assumptions

## How to Apply It (Brief)

1. Define a measurable outcome.
2. Map the customer journey to frame opportunity areas.
3. Capture opportunities from real interviews (stories, not preferences).
4. Organize opportunities into a tree from broad to specific.
5. Generate at least three solutions per high-priority opportunity.
6. Test the riskiest assumptions before building.
7. Review and update the tree weekly.

## Common Mistakes

- Write solutions as opportunities (see [opportunities-are-solutions](patterns/opportunities-are-solutions.md)).
- Skip outcomes or use outputs instead (see [skipping-outcome](patterns/skipping-outcome.md), [output-not-outcome](patterns/output-not-outcome.md)).
- Only explore one solution (see [single-solution-thinking](patterns/single-solution-thinking.md)).
- Build from assumptions instead of research (see [conference-room-opportunities](patterns/conference-room-opportunities.md)).

## Deep Dives

Read these only when you need the extra detail.

- `references/ost-playbook.md`: experience maps, opportunity decomposition, interview prompts, assumption testing, checklists, and collaboration notes.

## Resources

**Books:**
- *Continuous Discovery Habits* by Teresa Torres
- *Nudge* by Richard Thaler

**Online:**
- Product Talk (producttalk.org)
- learn.producttalk.org

**Related Frameworks:**
- Jobs to be Done
- Design Thinking
