---
title: Opportunities Should Nest Hierarchically
impact: HIGH
tags: structure, hierarchy, organization
---

## Opportunities Should Nest Hierarchically

A flat list of opportunities is just a backlog in disguise. The power of the tree is showing how small opportunities ladder up to bigger ones. This enables continuous progress on hard problems.

**Incorrect (flat opportunity list):**

> **OST under "Increase Engagement" outcome:**
>
> - Hard to find the right content
> - App crashes sometimes
> - Can't decide what to watch
> - Loading takes too long
> - Thumbnails are ugly
> - Search doesn't work well
> - Too many options
> - Content expires unexpectedly
> - Can't resume where I left off
>
> *Result:* This is a prioritized backlog, not a tree. No relationship between items. No sense of which opportunities are subsets of others. Every item competes equally for attention.

**Correct (hierarchical opportunity structure):**

> **OST under "Increase Engagement" outcome:**
>
> ```
> Opportunity: Deciding what to watch is frustrating (parent)
>     │
>     ├── I can't evaluate if content is good (child)
>     │       ├── Thumbnails don't convey quality
>     │       ├── Descriptions are vague
>     │       └── Can't tell what genre/mood
>     │
>     ├── There are too many options (child)
>     │       ├── Recommendations feel random
>     │       └── Categories don't match how I think
>     │
>     └── I can't find specific content I want (child)
>             ├── Search results are irrelevant
>             └── Can't browse by actor/director
>
> Opportunity: The viewing experience breaks flow (separate parent)
>     │
>     ├── Technical issues interrupt viewing
>     │       ├── App crashes mid-show
>     │       └── Loading buffers too long
>     │
>     └── Content management is confusing
>             ├── Can't resume where I left off
>             └── Things expire without warning
> ```
>
> *Result:* Clear relationships. "Thumbnails don't convey quality" is a solvable child that contributes to "I can't evaluate if content is good," which contributes to "Deciding what to watch is frustrating." Solving the child makes progress on the parent.

**Why it matters:**

Hierarchy enables strategy. You can decide to focus on "deciding what to watch" without addressing "viewing experience breaks flow." Within a parent, you can sequence children based on impact and effort. The tree makes the structure of your problem space visible.
