---
title: Structure Opportunities Around the Customer Journey
impact: HIGH
tags: experience-map, structure, customer-journey
---

## Structure Opportunities Around the Customer Journey

Don't organize opportunities by your team structure or product areas. Organize them by the customer's experience — the moments in time as they try to accomplish their goal.

**Incorrect (organized by internal structure):**

> **OST Opportunity Branches:**
>
> - Mobile team opportunities
> - Backend team opportunities
> - Search team opportunities
> - Content team opportunities
> - Growth team opportunities
>
> *Result:* Opportunities are siloed by who'll build them. Customer experience fragments across teams. No one owns "I can't decide what to watch" — pieces are scattered everywhere.

**Correct (organized by customer experience):**

> **OST Opportunity Branches (for streaming service):**
>
> **1. Trigger — I want to watch something**
> - I'm bored and don't know what to do
> - I need background noise while doing something else
> - I want to unwind after a hard day
>
> **2. Platform Selection — Where do I watch?**
> - I don't remember which service has what
> - Logging in is a hassle
> - Different services for different devices
>
> **3. Content Discovery — What should I watch?**
> - Can't decide among options
> - Can't find what I'm looking for
> - Can't tell if something is good
>
> **4. Viewing Experience — Am I enjoying this?**
> - Playback issues interrupt
> - Can't adjust to my environment (subtitles, volume)
> - I'm not sure if I like this show yet
>
> **5. Post-Viewing — What happens after?**
> - I want to watch more
> - I want to remember this for later
> - I want to tell friends about it
>
> *Result:* Opportunities cluster around moments in the customer journey. Any team can contribute to any moment. You see the full experience, not just your slice.

**Why it matters:**

Experience maps reveal opportunities that fall between teams. They ensure you're thinking about the customer's journey, not your org chart. The same experience map works whether you're Netflix or Hulu — human needs don't change based on who built the product.
