---
title: Decompose Big Opportunities Into Specific Moments
impact: HIGH
tags: opportunities, decomposition, specificity
---

## Decompose Big Opportunities Into Specific Moments

"Make it easier to use" is not actionable. Big, vague opportunities must be broken down into specific moments where friction actually occurs. You can't solve "easier" — you can solve "entering a password on Apple TV is miserable."

**Incorrect (opportunities too broad):**

> **OST Opportunity Branch:**
>
> - Make the product easier to use
> - Improve the onboarding experience
> - Help users get more value
> - Reduce friction
>
> *Result:* Where do you start? What does "success" look like? These are mission statements, not opportunities. Teams spin their wheels in abstract discussions.

**Correct (specific, decomposed opportunities):**

> **OST Opportunity Branch (Onboarding):**
>
> ```
> Opportunity: Onboarding is frustrating (big, evergreen)
>     │
>     ├── I don't understand what this product does after signup (medium)
>     │       ├── The welcome screen has too much text
>     │       └── There's no clear first action to take
>     │
>     ├── Setting up my account takes too long (medium)
>     │       ├── Entering my password on Apple TV remote is painful
>     │       ├── I have to enter the same info multiple times
>     │       └── The form asks for info I don't have right now
>     │
>     └── I can't tell if I did it right (medium)
>             ├── No confirmation that my settings saved
>             └── I don't know if I'm "done" with setup
> ```
>
> *Result:* "Entering my password on Apple TV remote is painful" is a real problem you can solve. Maybe voice input, maybe QR code from phone, maybe device linking. Now you're making progress on "onboarding is frustrating" one specific moment at a time.

**Why it matters:**

The power of the OST is vertical decomposition. Big opportunities are evergreen — Netflix will work on "hard to decide what to watch" forever. Small opportunities are solvable. Each solved opportunity contributes to the parent. You never stop, but you always ship.
