---
title: Outcomes Are Not Outputs
impact: HIGH
tags: outcomes, outputs, goals
---

## Outcomes Are Not Outputs

An output is something you ship. An outcome is the behavior change that results. "Launch the redesign" is an output — you control it completely. "Increase activation by 10%" is an outcome — it depends on customer behavior.

**Incorrect (outputs masquerading as outcomes):**

> **Team's OST:**
>
> ```
> Outcome: Ship the new onboarding flow
>     └── Opportunity: We need a better onboarding flow
>             └── Solution: Build the new onboarding flow
> ```
>
> **Also seen:**
> - "Outcome: Complete the mobile app redesign"
> - "Outcome: Launch feature X by Q2"
> - "Outcome: Integrate with partner API"
>
> *Result:* The tree becomes a project plan. No room for discovering whether the onboarding flow actually works. Success is defined by delivery, not impact. If the flow ships and activation doesn't improve, you "succeeded" — but did you?

**Correct (real outcomes):**

> **Team's OST:**
>
> ```
> Outcome: Increase Day-7 activation from 20% to 35%
>     │
>     ├── Opportunity: New users don't understand the value
>     │       ├── Solution: Interactive first-run experience
>     │       ├── Solution: Personalized onboarding based on use case
>     │       └── Solution: Progress indicator with clear milestones
>     │
>     ├── Opportunity: Setup feels like too much work
>     │       ├── Solution: Reduce required steps
>     │       ├── Solution: Allow incomplete setup, prompt later
>     │       └── Solution: Import settings from similar tools
>     │
>     └── Opportunity: Users don't return after day 1
>             ├── Solution: Follow-up email with personalized tips
>             └── Solution: In-app reminder of unfinished tasks
> ```
>
> *Result:* Success is defined by customer behavior change, not feature delivery. Multiple solutions compete. You might ship 3 things that don't work and then find the one that does. The outcome remains constant; the solutions evolve.

**Why it matters:**

Outputs are within your control. Outcomes depend on customer behavior. If you can guarantee the outcome just by doing the work, it's not an outcome. Real outcomes require discovery because you can't know in advance what will work.
