---
title: Always Compare Multiple Solutions
impact: HIGH
tags: solutions, decision-making, comparison
---

## Always Compare Multiple Solutions

If you only have one solution per opportunity, you haven't explored enough. Good decisions require options. You don't look at one apartment when moving — the same applies to product solutions.

**Incorrect (single solution per opportunity):**

> **OST Branch:**
>
> ```
> Opportunity: Users can't tell if a show is good
>     └── Solution: Add user ratings
> ```
>
> **Team Discussion:** "Should we build ratings?"
>
> *Result:* The debate becomes binary: build it or don't. No understanding of trade-offs. No exploration of what else might work. If ratings don't test well, you're back to square one.

**Correct (multiple solutions per opportunity):**

> **OST Branch:**
>
> ```
> Opportunity: Users can't tell if a show is good
>     ├── Solution: Add user ratings (like IMDB)
>     ├── Solution: Show cast and creator info
>     ├── Solution: Personalized "why you'll like this" explanations
>     ├── Solution: Preview clips that reveal tone/quality
>     └── Solution: "People like you watched this" social proof
> ```
>
> **Team Discussion:** "Which of these best addresses the opportunity?"
>
> | Solution | Effort | Risk | Signal strength |
> |----------|--------|------|-----------------|
> | User ratings | Medium | Medium (gaming) | High |
> | Cast info | Low | Low | Medium |
> | Personalized explanations | High | High (might feel creepy) | High |
> | Preview clips | Medium | Low | High |
> | Social proof | Medium | Medium (privacy) | Medium |
>
> *Result:* The team can make informed trade-offs. They might start with preview clips (low risk, high signal) while exploring personalized explanations for later.

**Why it matters:**

Multiple solutions prevent premature commitment. They expose hidden assumptions. They let you compare and contrast. If you're not generating at least 3 solutions per opportunity, you're limiting your thinking.
