---
title: Don't Skip the Outcome
impact: CRITICAL
tags: outcomes, prioritization, strategy
---

## Don't Skip the Outcome

Without a clear outcome, you can't prioritize opportunities. Everything seems important because you have no basis for trade-offs. The outcome is your filter for what matters.

**Incorrect (no outcome, floating opportunities):**

> **Product Team's Discovery Backlog:**
>
> - Customers struggle with onboarding
> - Power users want more advanced features
> - Mobile experience is clunky
> - Search results aren't relevant
> - Users forget their passwords
>
> **PM:** "Which should we work on first?"
>
> **Designer:** "Onboarding seems important."
>
> **Engineer:** "But power users pay the most."
>
> *Result:* Debate goes in circles. No way to resolve disagreement. The loudest voice or highest-paid opinion wins.

**Correct (outcome-driven prioritization):**

> **Outcome:** Increase 30-day retention from 25% to 35%
>
> **Re-evaluating opportunities:**
>
> | Opportunity | Impact on 30-day retention? |
> |-------------|----------------------------|
> | Onboarding struggles | High — they churn before day 7 |
> | Advanced features for power users | Low — power users already retain |
> | Clunky mobile experience | Medium — some churn, but not primary |
> | Irrelevant search | Medium — causes frustration but not churn |
> | Password reset | Low — rare edge case |
>
> *Result:* Onboarding is the clear priority. The outcome made the decision obvious.

**Why it matters:**

Your outcome is not "build good stuff." It's a specific, measurable result the business needs. That specificity is what enables real prioritization. If you can't articulate your outcome, you don't know why you're doing discovery.
