---
title: Don't Start with Solutions
impact: CRITICAL
tags: process, solutions, discovery
---

## Don't Start with Solutions

Teams often have a feature in mind and work backward to justify it. This defeats the purpose of the tree. If you've already decided what to build, don't pretend you're doing discovery.

**Incorrect (solution-first thinking):**

> **Product Manager:** "Leadership wants us to build a recommendation engine. Let's create an OST to figure out how."
>
> **The Tree:**
> ```
> Outcome: Increase engagement
>     └── Opportunity: Users need better recommendations
>             └── Solution: Build recommendation engine
> ```
>
> *Result:* The opportunity was invented to justify the solution. No one asked if recommendations are actually a pain point. No alternative solutions were considered. The tree is decoration, not discovery.

**Correct (outcome-first thinking):**

> **Product Manager:** "We need to increase engagement. Let's understand what's blocking it."
>
> **The Tree:**
> ```
> Outcome: Increase engagement
>     ├── Opportunity: I can't decide what to watch (from 8 interviews)
>     │       ├── Solution: Recommendation engine
>     │       ├── Solution: "Continue watching" prominence
>     │       └── Solution: Curated collections by mood
>     ├── Opportunity: I forget this app exists (from 5 interviews)
>     │       ├── Solution: Push notifications
>     │       ├── Solution: Email digest
>     │       └── Solution: Calendar integration
>     └── Opportunity: The viewing experience is frustrating (from 3 interviews)
>             └── [solutions...]
> ```
>
> *Result:* Recommendations might still win, but now you know why. You've considered alternatives. Leadership can see the reasoning.

**Why it matters:**

If you start with a solution, you'll find evidence to support it and ignore evidence against it. Real discovery means being genuinely curious about what's blocking your outcome — even if the answer contradicts what leadership wants.
