---
title: Limit Top-Level Branches for Cognitive Manageability
impact: MEDIUM
tags: structure, prioritization, focus
---

## Limit Top-Level Branches for Cognitive Manageability

If your tree has 15 top-level opportunity branches, you can't hold them all in your head. The tree loses its power as a decision-making tool. Aim for 5-7 top-level branches, aligned to your experience map.

**Incorrect (too many top-level branches):**

> **OST Top-Level Opportunities:**
>
> 1. Hard to find content
> 2. Can't decide what to watch
> 3. Recommendations aren't good
> 4. Search is broken
> 5. Too many options
> 6. Thumbnails are unhelpful
> 7. Descriptions don't help
> 8. Loading is slow
> 9. App crashes
> 10. Can't resume where I left off
> 11. Content expires unexpectedly
> 12. Logging in is hard
> 13. Different experience on different devices
> 14. Can't share with friends
> 15. Notifications are annoying
>
> *Result:* This is a backlog, not a tree. No structure. No hierarchy. Impossible to see relationships. Every standup becomes "which of these 15 things?"

**Correct (focused top-level with depth):**

> **OST Top-Level Opportunities (mapped to experience):**
>
> **1. Deciding to watch (Trigger)**
> - [Sub-opportunities about what prompts viewing]
>
> **2. Choosing a platform (Selection)**
> - Logging in is hard
> - Different experience across devices
>
> **3. Finding and evaluating content (Discovery)**
> - Hard to find content
> - Can't decide what to watch
> - Recommendations aren't good
> - Search is broken
> - Thumbnails and descriptions don't help
>
> **4. The viewing experience (Consumption)**
> - Loading is slow
> - App crashes
> - Can't resume where I left off
>
> **5. After viewing (Post-watch)**
> - Can't share with friends
> - Content expires unexpectedly
> - Notifications are annoying
>
> *Result:* 5 top-level branches. You can hold them in your head. Within each branch, sub-opportunities nest logically. You can focus a quarter on "Finding and evaluating content" without ignoring that other branches exist.

**Why it matters:**

Miller's Law suggests humans can hold 7 (plus or minus 2) items in working memory. Your tree should respect this. Use hierarchy to manage complexity — more depth, not more breadth.
