---
title: Update the Tree as You Learn
impact: MEDIUM
tags: process, continuous, maintenance
---

## Update the Tree as You Learn

The OST is not a one-time artifact. It's a living document that evolves weekly as you interview customers, test assumptions, and learn what works. A static tree means you've stopped learning.

**Incorrect (static tree):**

> **Q1 Planning:**
> "We built our OST in our planning session. Here are the three opportunities we'll focus on this quarter."
>
> **Week 4:**
> (Same tree, unchanged)
>
> **Week 8:**
> (Same tree, unchanged)
>
> **Week 12:**
> PM: "We shipped all our solutions but the outcome didn't move."
> Leadership: "What did you learn?"
> PM: "Um... we learned those solutions didn't work?"
>
> *Result:* The tree became a roadmap artifact, not a discovery tool. No new opportunities added. No solutions pruned based on learning. No visible record of what you tried and why it failed.

**Correct (evolving tree):**

> **Week 1:**
> Initial tree with 3 opportunity branches from 8 interviews
>
> **Week 4:**
> - Added new opportunity: "I can't remember what episode I was on" (heard in 3 interviews)
> - Deprioritized: "Content expires without warning" (only 1 user mentioned it)
> - Tested assumption on Solution A — failed, removed from tree
>
> **Week 8:**
> - Decomposed "Can't decide what to watch" into 4 specific sub-opportunities
> - Added Solution D after competitor analysis
> - Marked Solution B as "in development" after passing assumption tests
>
> **Week 12:**
> - Tree shows: 2 shipped solutions (impact measured), 3 killed solutions (with learnings), 5 new opportunities discovered, 2 solutions in testing
>
> *Result:* The tree is a visual history of your discovery. Anyone can see what you learned, what you tried, and why you made the decisions you did.

**Why it matters:**

If your tree looks the same in week 1 and week 12, you didn't do continuous discovery — you did quarterly planning with extra steps. The tree should be your team's shared brain, updated every time you learn something new.
