---
name: pmf-survey
description: Use when asked to "PMF survey", "measure product-market fit", "40% rule", "Sean Ellis test", "Rahul Vohra method", or "how disappointed would you be". Helps quantify product-market fit and systematically improve it. The PMF Survey framework (created by Sean Ellis, popularized by Rahul Vohra at Superhuman) measures how disappointed users would be without your product and turns that data into a roadmap.
---

# PMF Survey (Product-Market Fit Survey)

## What It Is

The PMF Survey is a method to **measure and systematically improve product-market fit**. The core insight: you can put a number on product-market fit, and you can use that number to write your roadmap.

The key question: "How would you feel if you could no longer use this product?"

- **Very disappointed** - "I'd be devastated. I need this."
- **Somewhat disappointed** - "I'd be bummed but I'd find something else."
- **Not disappointed** - "I wouldn't really care."

Sean Ellis discovered that companies with **40% or more "very disappointed" responses** almost always grew successfully, while those under 40% struggled. This benchmark has held across thousands of companies.

Rahul Vohra at Superhuman took this further: he built an engine that uses survey responses to algorithmically generate a roadmap guaranteed to increase PMF score.

## When to Use It

Use the PMF Survey when you need to:

- **Quantify product-market fit** before making major investment decisions
- **Decide whether to pivot** or double down
- **Prioritize your roadmap** based on what will actually move the needle
- **Identify your best customer segment** (who loves you most)
- **Track PMF over time** as you iterate
- **Make the case to investors** with data, not gut feeling

## When Not to Use It

- You have fewer than 30 active users (sample too small)
- Users haven't had enough time to experience value (survey too early)
- The product is employer-mandated (users had no choice)
- You want to validate a hypothesis without building (use JTBD instead)

## Patterns

Detailed examples showing how to apply the PMF Survey correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [survey-question-wording](patterns/survey-question-wording.md) | Use the exact wording - variations invalidate the benchmark |
| [who-to-survey](patterns/who-to-survey.md) | Only survey users who experienced the core value |
| [forty-percent-benchmark](patterns/forty-percent-benchmark.md) | 40% is a threshold, not a target - understand what it means |
| [ignoring-somewhat-disappointed](patterns/ignoring-somewhat-disappointed.md) | The "somewhat disappointed" segment is your growth engine |
| [segment-before-action](patterns/segment-before-action.md) | You must segment responses before acting on feedback |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [sample-size-myths](patterns/sample-size-myths.md) | 40-50 responses is enough - don't wait for statistical perfection |
| [wrong-timing](patterns/wrong-timing.md) | Survey after first value, not after signup |
| [acting-on-not-disappointed](patterns/acting-on-not-disappointed.md) | Stop trying to convert the "not disappointed" users |
| [main-benefit-filter](patterns/main-benefit-filter.md) | Only act on feedback from users who love your core value |
| [doubling-down-vs-fixing](patterns/doubling-down-vs-fixing.md) | Half your time on strengths, half on objections |
| [high-expectation-customers](patterns/high-expectation-customers.md) | Learn your ideal customer profile from users who love you |
| [pivot-vs-persevere](patterns/pivot-vs-persevere.md) | Check for segment-level PMF before deciding to pivot |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [tracking-over-time](patterns/tracking-over-time.md) | How to measure PMF progress without invalidating comparisons |
| [follow-up-questions](patterns/follow-up-questions.md) | The three questions that unlock the roadmap algorithm |
| [enterprise-vs-consumer](patterns/enterprise-vs-consumer.md) | Adapting the survey for B2B vs B2C contexts |


## Deep Dives

Read only when you need extra detail.

- `references/pmf-survey-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Articles:**
- *How Superhuman Built an Engine to Find Product-Market Fit* by Rahul Vohra (First Round Review) - the definitive guide
- Sean Ellis's original PMF survey methodology

**Books:**
- *Hacking Growth* by Sean Ellis - context on growth and PMF metrics
- *The Lean Startup* by Eric Ries - complementary framework for validation

**Podcasts:**
- Lenny's Podcast episode with Rahul Vohra - deep dive on the methodology and how Superhuman applied it

**Credits:**
- **Sean Ellis** - Created the original PMF survey question and discovered the 40% benchmark
- **Rahul Vohra** - Popularized the methodology and built the "PMF Engine" algorithm for systematically improving the score
