---
title: Adapting the Survey for B2B vs B2C Contexts
impact: MEDIUM
tags: b2b, enterprise, methodology
---

## Adapting the Survey for B2B vs B2C Contexts

The PMF survey works for both B2B and B2C, but B2B requires considering multiple stakeholders. The user and the buyer may have different levels of disappointment.

**Incorrect (treating B2B like B2C):**

> **Context:** Enterprise project management tool
>
> **Survey sent to:** All users in all accounts
>
> **Results:** 45% very disappointed
>
> **Team's conclusion:** "Great PMF! Let's scale."
>
> *Six months later:* Enterprise deals stalling. Buyers saying "My team likes it but I don't see the ROI."

You measured user satisfaction but enterprise purchases are made by buyers who may never use the product.

**Correct (multi-stakeholder approach):**

> **Context:** Enterprise project management tool
>
> **Survey approach:**
>
> **End users:**
> - "How would you feel if you could no longer use [product]?"
> - Result: 45% very disappointed
>
> **Decision makers/buyers (separate survey):**
> - "How would you feel if your team could no longer use [product]?"
> - Result: 22% very disappointed
>
> **Analysis:** "Users love us but buyers don't see the value. We have a positioning/ROI problem, not a product problem."
>
> **Action:** Improve executive-facing dashboards and ROI reporting to demonstrate value to buyers.

In B2B, you may have PMF with users but not with buyers. Both matter for growth.

**Why it matters:**

B2B purchases involve multiple personas with different jobs. High user PMF with low buyer PMF means you'll win pilots but lose deals. Measure both to understand where your actual blockers are.
