---
title: 40% Is a Threshold, Not a Target
impact: CRITICAL
tags: benchmark, interpretation, strategy
---

## 40% Is a Threshold, Not a Target

Teams treat 40% like a finish line or a binary pass/fail. It's neither. It's a signal about where you are in the journey and what to do next.

**Incorrect (binary thinking):**

> **PMF Score:** 39%
>
> **Team's conclusion:** "We failed. We don't have PMF. Should we pivot?"
>
> ---
>
> **PMF Score:** 41%
>
> **Team's conclusion:** "We passed! We have PMF. Time to scale aggressively."

Both conclusions miss the point. 39% vs 41% is within margin of error. And "having PMF" isn't a permanent state you achieve.

**Correct (threshold thinking):**

> **PMF Score:** 39%
>
> **Team's conclusion:** "We're close to the threshold where companies typically succeed at scaling. Let's identify the 'somewhat disappointed' users who love our core benefit and see what's holding them back. A few targeted improvements could push us over."
>
> ---
>
> **PMF Score:** 41%
>
> **Team's conclusion:** "We're above the threshold - we have permission to invest in growth. But 41% isn't great, it's baseline. Let's continue improving PMF while scaling, and watch for any regression."

The 40% threshold tells you: below it, growth will be inefficient (you're pushing water uphill). Above it, growth becomes possible (gravity is on your side). Neither state is permanent.

**Why it matters:**

Companies that treat 40% as pass/fail either give up too early (39%) or stop improving too soon (41%). PMF is a continuous variable, not a checkbox. Use the number to calibrate effort, not to declare victory or defeat.
