---
title: Using PMF Score to Decide Pivot vs Persevere
impact: HIGH
tags: strategy, pivot, decision-making
---

## Using PMF Score to Decide Pivot vs Persevere

The PMF survey can inform pivot decisions, but a low score alone doesn't mean you should pivot. First, check if there's a segment with strong PMF hiding in the aggregate data.

**Incorrect (pivoting on aggregate score):**

> **PMF Score:** 18% very disappointed
>
> **Team's reaction:** "We're way below 40%. This isn't working. Let's pivot to a different market or product."
>
> *After pivot:* New product also struggles. Team realizes they abandoned users who actually loved them.

**Correct (segmenting before deciding):**

> **Overall PMF Score:** 18% very disappointed
>
> **Team's analysis:** "Let's segment the data before deciding."
>
> **Segment analysis:**
> - Solo consultants: 8% very disappointed (low)
> - Small teams (2-5): 12% very disappointed (low)
> - Agencies (6-20): 47% very disappointed (strong!)
> - Enterprise (50+): 5% very disappointed (very low)
>
> **Insight:** "We have strong PMF with agencies. Our aggregate score is low because we're attracting too many wrong-fit users."
>
> **Decision:** "Don't pivot. Instead, focus exclusively on agencies. Improve positioning to attract more agencies, fewer others. Our aggregate score will rise as our user mix shifts."

A 47% PMF score in a segment of your market is product-market fit. The problem may be positioning and acquisition, not the product.

**Why it matters:**

Aggregate PMF scores hide segment-level signal. Before pivoting, check if you have strong PMF with any segment. If yes, double down on that segment. Pivoting throws away hard-won learning about who loves you and why.
