---
title: You Must Segment Before Acting on Feedback
impact: CRITICAL
tags: segmentation, analysis, roadmap
---

## You Must Segment Before Acting on Feedback

Aggregating all feedback and building the most-requested features is a trap. Different user segments want different things, and some segments will lead you astray.

**Incorrect (acting on aggregate feedback):**

> **Survey improvement suggestions (all users combined):**
> - "Add more integrations" - 45 mentions
> - "Make it faster" - 32 mentions
> - "Add dark mode" - 28 mentions
> - "Better mobile app" - 24 mentions
>
> **Product decision:** Prioritize integrations, then speed, then dark mode.
>
> *Three months later:* PMF score unchanged. "Very Disappointed" users complaining that the product is losing focus.

You built what the crowd wanted, but the crowd included people who don't love your core value.

**Correct (segmented analysis):**

> **Segment the feedback by disappointment level:**
>
> **"Very Disappointed" improvement requests:**
> - "Make it faster" - 28 mentions
> - "Better keyboard shortcuts" - 18 mentions
>
> **"Somewhat Disappointed" (main benefit = speed) requests:**
> - "Better mobile app" - 20 mentions
> - "Fix sync reliability" - 15 mentions
>
> **"Somewhat Disappointed" (main benefit = something else) requests:**
> - "Add more integrations" - 25 mentions
>
> **"Not Disappointed" requests:**
> - "Add dark mode" - 22 mentions
> - "Add more integrations" - 18 mentions
>
> **Product decision:** Speed and keyboard shortcuts (protect lovers) + mobile app and sync (convert fence-sitters). Ignore integrations and dark mode requests.

"Integrations" was the top aggregate request but came mostly from users who don't love your core value. Building it would dilute your product.

**Why it matters:**

Unsegmented feedback is democracy where every vote counts equally. But users who love you and users who don't care have fundamentally different needs. Treat their votes equally and you'll build a product nobody loves.
